/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Attr;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

public class SOAPUtils {
    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public static String basicWrapInSoapEnvelopeDocument(String xml) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version='1.0' encoding='UTF-8'?>");
        sb.append("<SOAP:Envelope xmlns:SOAP=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">");
        sb.append("<SOAP:Body ");
        sb.append("SOAP:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" ");
        sb.append(">");
        sb.append(xml);
        sb.append("</SOAP:Body>");
        sb.append("</SOAP:Envelope>");
        return sb.toString();
    }

    public static String basicWrapInSoapEnvelopeRPC(String xml, String operationNamespace, String operation) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version='1.0' encoding='UTF-8'?>");
        sb.append("<SOAP:Envelope xmlns:SOAP=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">");
        sb.append("<SOAP:Body ");
        sb.append("SOAP:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" ");
        sb.append(">");
        sb.append("<opns:").append(operation).append(" xmlns:opns=\"").append(operationNamespace).append("\" ");
        sb.append("xmlns:xsi=\"").append("http://www.w3.org/1999/XMLSchema-instance").append("\" ");
        sb.append("xmlns:xsd=\"").append("http://www.w3.org/1999/XMLSchema").append("\" ");
        sb.append(">");
        sb.append(xml);
        sb.append("</opns:").append(operation).append(">");
        sb.append("</SOAP:Body>");
        sb.append("</SOAP:Envelope>");
        return sb.toString();
    }

    public static void gatherNamespaces(ArrayList namespaces, Element elem) {
        NamedNodeMap map = elem.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr attr = (Attr)map.item(i);
            if (attr.getName().toLowerCase().startsWith("xmlns:")) {
                namespaces.add(attr);
            }
            ++i;
        }
    }

    public static void dumpNamespaces(ArrayList namespaces, Element elem) {
        int i = namespaces.size() - 1;
        while (i >= 0) {
            Attr attr = (Attr)namespaces.get(i);
            if (!elem.hasAttribute(attr.getNodeName())) {
                elem.setAttribute(attr.getName(), attr.getValue());
            }
            --i;
        }
    }

    public static String basicRemoveSoapEnvelopeDocument(String xml) throws Exception {
        ArrayList namespaces = new ArrayList();
        Document doc = XMLUtil.documentFromString(xml);
        SOAPUtils.gatherNamespaces(namespaces, doc.getDocumentElement());
        NodeList envs = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < envs.getLength()) {
            Node n = envs.item(i);
            if (n.getNodeType() == Node.ELEMENT_NODE && n.getNodeName().endsWith("Body")) {
                SOAPUtils.gatherNamespaces(namespaces, (Element)n);
                NodeList nodes = n.getChildNodes();
                int z = 0;
                while (z < nodes.getLength()) {
                    if (nodes.item(z).getNodeType() == Node.ELEMENT_NODE) {
                        SOAPUtils.dumpNamespaces(namespaces, (Element)nodes.item(z));
                    }
                    ++z;
                }
                return XMLUtil.nodeChildrenToString(n);
            }
            ++i;
        }
        throw new Exception("found no valid response");
    }

    public static String basicRemoveSoapEnvelopeRPC(String xml) throws Exception {
        ArrayList namespaces = new ArrayList();
        Document doc = XMLUtil.documentFromString(xml);
        SOAPUtils.gatherNamespaces(namespaces, doc.getDocumentElement());
        NodeList envs = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < envs.getLength()) {
            Node n = envs.item(i);
            if (n.getNodeType() == Node.ELEMENT_NODE && n.getNodeName().endsWith("Body")) {
                SOAPUtils.gatherNamespaces(namespaces, (Element)n);
                NodeList responses = n.getChildNodes();
                int k = 0;
                while (k < responses.getLength()) {
                    Node response = responses.item(k);
                    if (response.getNodeType() == Node.ELEMENT_NODE) {
                        SOAPUtils.gatherNamespaces(namespaces, (Element)response);
                        NodeList nodes = response.getChildNodes();
                        int z = 0;
                        while (z < nodes.getLength()) {
                            if (nodes.item(z).getNodeType() == Node.ELEMENT_NODE) {
                                SOAPUtils.dumpNamespaces(namespaces, (Element)nodes.item(z));
                            }
                            ++z;
                        }
                        return XMLUtil.nodeChildrenToString(response);
                    }
                    ++k;
                }
            }
            ++i;
        }
        throw new Exception("found no valid response");
    }
}

