/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.misc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class XMLConfigUtil {
    public static DocumentBuilder getDocumentBuilder() throws Exception {
        return new DocumentBuilder();
    }

    public static void getXmlHead(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
            ++i;
        }
        sb.append(">\n");
    }

    public static void getXmlTail(StringBuffer sb, Element e) {
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static String toRawXML(Node n) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toRawXML(sb, n);
        return sb.toString();
    }

    public static String toRawXML(String val) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < val.length()) {
            char c = val.charAt(i);
            if (c == '>') {
                sb.append("&gt;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static void toRawXML(StringBuffer sb, Node n) {
        if (n.getNodeType() == Node.ELEMENT_NODE) {
            XMLConfigUtil.toXML(sb, (Element)n);
        } else if (n.getNodeType() == Node.TEXT_NODE) {
            String val = n.getNodeValue();
            sb.append(XMLConfigUtil.toRawXML(val));
        }
    }

    public static String toXML(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLConfigUtil.toXML(sb, e);
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, Element e) {
        sb.append("<");
        sb.append(e.getTagName());
        sb.append(" ");
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            sb.append(node.getNodeName());
            sb.append("=\"");
            sb.append(XMLConfigUtil.toRawXML(node.getNodeValue()));
            sb.append("\" ");
            ++i;
        }
        sb.append(">\n");
        ArrayList list = XMLConfigUtil.getAllElements(e.getChildNodes(), null);
        int i2 = 0;
        while (i2 < list.size()) {
            Element x = (Element)list.get(i2);
            XMLConfigUtil.toXML(sb, x);
            ++i2;
        }
        sb.append("</");
        sb.append(e.getTagName());
        sb.append(">\n");
    }

    public static Element getFirstElement(NodeList list, String name) {
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name)) {
                        return e;
                    }
                } else {
                    return e;
                }
            }
            ++i;
        }
        return null;
    }

    public static ArrayList getAllElements(NodeList list, String name) {
        ArrayList<Node> elements = new ArrayList<Node>();
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name)) {
                        elements.add(o);
                    }
                } else {
                    elements.add(o);
                }
            }
            ++i;
        }
        return elements;
    }

    public static void getElementAttributeMap(NodeList list, String name, String attribute, HashMap map) {
        int i = 0;
        while (i < list.getLength()) {
            Node o = list.item(i);
            if (o instanceof Element) {
                String attr;
                Element e = (Element)o;
                if (name != null) {
                    if (e.getTagName().equals(name) && (attr = e.getAttribute(attribute)) != null) {
                        map.put(attr, e);
                    }
                } else {
                    attr = e.getAttribute(attribute);
                    if (attr != null) {
                        map.put(attr, e);
                    }
                }
            }
            ++i;
        }
    }

    public static HashMap getElementAttributeMap(NodeList list, String name, String attribute) {
        HashMap map = new HashMap();
        XMLConfigUtil.getElementAttributeMap(list, name, attribute, map);
        return map;
    }

    public static double parseDouble(String doub, double def) {
        try {
            return Double.parseDouble(doub);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static boolean parseBoolean(String bool, boolean def) {
        if (bool.equals("true")) {
            return true;
        }
        if (bool.equals("false")) {
            return false;
        }
        return def;
    }

    public static int parseLineStyle(String style, int def) {
        if (style.equals("SOLID")) {
            return 1;
        }
        if (style.equals("DOT")) {
            return 3;
        }
        if (style.equals("DASH")) {
            return 2;
        }
        if (style.equals("DASHDOT")) {
            return 4;
        }
        if (style.equals("DASHDOTDOT")) {
            return 5;
        }
        return def;
    }

    public static RGB parseColor(String col, RGB def) {
        try {
            if (!col.startsWith("#")) {
                throw new Exception();
            }
            if (col.length() != 7) {
                throw new Exception();
            }
            String sr = col.substring(1, 3);
            String sg = col.substring(3, 5);
            String sb = col.substring(5, 7);
            int r = Integer.parseInt(sr, 16);
            int g = Integer.parseInt(sg, 16);
            int b = Integer.parseInt(sb, 16);
            return new RGB(r, g, b);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public static String colorToString(Color c) {
        RGB rgb = c.getRGB();
        String s = "#";
        if (rgb.red < 16) {
            s = String.valueOf(s) + "0";
        }
        s = String.valueOf(s) + Integer.toString(rgb.red, 16);
        if (rgb.green < 16) {
            s = String.valueOf(s) + "0";
        }
        s = String.valueOf(s) + Integer.toString(rgb.green, 16);
        if (rgb.blue < 16) {
            s = String.valueOf(s) + "0";
        }
        s = String.valueOf(s) + Integer.toString(rgb.blue, 16);
        return s;
    }

    public static String lineStyleToString(int style) {
        if (style == 1) {
            return "SOLID";
        }
        if (style == 3) {
            return "DOT";
        }
        if (style == 2) {
            return "DASH";
        }
        if (style == 4) {
            return "DASHDOT";
        }
        if (style == 5) {
            return "DASHDOTDOT";
        }
        return "SOLID";
    }
}

