/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.examples.logicdesigner.model.LogicGuide;
import org.eclipse.gef.examples.logicdesigner.model.LogicRuler;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class DeleteGuideCommand
extends Command {
    private LogicRuler parent;
    private LogicGuide guide;
    private Map oldParts;

    public DeleteGuideCommand(LogicGuide guide, LogicRuler parent) {
        super(LogicMessages.DeleteGuideCommand_Label);
        this.guide = guide;
        this.parent = parent;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldParts = new HashMap(this.guide.getMap());
        Iterator iter = this.oldParts.keySet().iterator();
        while (iter.hasNext()) {
            this.guide.detachPart((LogicSubpart)iter.next());
        }
        this.parent.removeGuide(this.guide);
    }

    public void undo() {
        this.parent.addGuide(this.guide);
        Iterator iter = this.oldParts.keySet().iterator();
        while (iter.hasNext()) {
            LogicSubpart part = (LogicSubpart)iter.next();
            this.guide.attachPart(part, (Integer)this.oldParts.get(part));
        }
    }
}

