/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.flow.model.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.flow.model.Activity;
import org.eclipse.gef.examples.flow.model.StructuredActivity;
import org.eclipse.gef.examples.flow.model.Transition;

public class DeleteCommand
extends Command {
    private Activity child;
    private StructuredActivity parent;
    private int index = -1;
    private List sourceConnections = new ArrayList();
    private List targetConnections = new ArrayList();

    private void deleteConnections(Activity a) {
        if (a instanceof StructuredActivity) {
            List children = ((StructuredActivity)a).getChildren();
            int i = 0;
            while (i < children.size()) {
                this.deleteConnections((Activity)children.get(i));
                ++i;
            }
        }
        this.sourceConnections.addAll(a.getIncomingTransitions());
        int i = 0;
        while (i < this.sourceConnections.size()) {
            Transition t = (Transition)this.sourceConnections.get(i);
            t.source.removeOutput(t);
            a.removeInput(t);
            ++i;
        }
        this.targetConnections.addAll(a.getOutgoingTransitions());
        i = 0;
        while (i < this.targetConnections.size()) {
            Transition t = (Transition)this.targetConnections.get(i);
            t.target.removeInput(t);
            a.removeOutput(t);
            ++i;
        }
    }

    public void execute() {
        this.primExecute();
    }

    protected void primExecute() {
        this.deleteConnections(this.child);
        this.index = this.parent.getChildren().indexOf(this.child);
        this.parent.removeChild(this.child);
    }

    public void redo() {
        this.primExecute();
    }

    private void restoreConnections() {
        Transition t;
        int i = 0;
        while (i < this.sourceConnections.size()) {
            t = (Transition)this.sourceConnections.get(i);
            t.target.addInput(t);
            t.source.addOutput(t);
            ++i;
        }
        this.sourceConnections.clear();
        i = 0;
        while (i < this.targetConnections.size()) {
            t = (Transition)this.targetConnections.get(i);
            t.source.addOutput(t);
            t.target.addInput(t);
            ++i;
        }
        this.targetConnections.clear();
    }

    public void setChild(Activity a) {
        this.child = a;
    }

    public void setParent(StructuredActivity sa) {
        this.parent = sa;
    }

    public void undo() {
        this.parent.addChild(this.child, this.index);
        this.restoreConnections();
    }
}

