/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.internal.EMFWorkspacePlugin;
import org.eclipse.emf.workspace.internal.Tracing;
import org.eclipse.emf.workspace.internal.l10n.Messages;
import org.eclipse.emf.workspace.util.ChangedSynchRequest;
import org.eclipse.emf.workspace.util.DeletedSynchRequest;
import org.eclipse.emf.workspace.util.MovedSynchRequest;
import org.eclipse.emf.workspace.util.SynchRequest;

public final class WorkspaceSynchronizer {
    private final TransactionalEditingDomain domain;
    private Delegate delegate;
    private static Collection synchronizers = new ArrayList();
    private static IResourceChangeListener workspaceListener = new WorkspaceListener();
    static Delegate defaultDelegate = new DefaultDelegate();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public WorkspaceSynchronizer(TransactionalEditingDomain domain) {
        this(domain, null);
    }

    public WorkspaceSynchronizer(TransactionalEditingDomain domain, Delegate delegate) {
        if (domain == null) {
            throw new IllegalArgumentException("null domain");
        }
        if (delegate == null) {
            delegate = defaultDelegate;
        }
        this.domain = domain;
        this.delegate = delegate;
        WorkspaceSynchronizer.startListening(this);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    Delegate getDelegate() {
        return this.delegate;
    }

    public void dispose() {
        WorkspaceSynchronizer.stopListening(this);
        this.delegate.dispose();
        this.delegate = null;
    }

    void processDelta(IResourceDelta delta, List synchRequests) {
        Resource resource = this.getEditingDomain().getResourceSet().getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString()), false);
        if (resource != null && resource.isLoaded()) {
            switch (delta.getKind()) {
                case 2: {
                    if ((delta.getFlags() & 0x2000) != 0) {
                        synchRequests.add(new MovedSynchRequest(this, resource, URI.createPlatformResourceURI((String)delta.getMovedToPath().toString())));
                        break;
                    }
                    synchRequests.add(new DeletedSynchRequest(this, resource));
                    break;
                }
                case 4: {
                    synchRequests.add(new ChangedSynchRequest(this, resource));
                }
            }
        }
    }

    public static IFile getFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return WorkspaceSynchronizer.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null);
    }

    private static IFile getFile(URI uri, URIConverter converter) {
        URI normalized;
        IFile result = null;
        if ("platform".equals(uri.scheme()) && uri.segmentCount() > 2) {
            if ("resource".equals(uri.segment(0))) {
                IPath path = new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
                result = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (converter != null && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            result = WorkspaceSynchronizer.getFile(normalized, converter);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startListening(WorkspaceSynchronizer synchronizer) {
        Collection collection = synchronizers;
        synchronized (collection) {
            ArrayList<WorkspaceSynchronizer> newList = new ArrayList<WorkspaceSynchronizer>(synchronizers.size() + 1);
            newList.addAll(synchronizers);
            newList.add(synchronizer);
            synchronizers = newList;
            ResourcesPlugin.getWorkspace().addResourceChangeListener(workspaceListener, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopListening(WorkspaceSynchronizer synchronizer) {
        Collection collection = synchronizers;
        synchronized (collection) {
            ArrayList newList = new ArrayList(synchronizers);
            newList.remove(synchronizer);
            synchronizers = newList;
            if (synchronizers.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(workspaceListener);
            }
        }
    }

    static Collection getSynchronizers() {
        return synchronizers;
    }

    private static class DefaultDelegate
    implements Delegate {
        private DefaultDelegate() {
        }

        public boolean handleResourceDeleted(Resource resource) {
            resource.unload();
            return true;
        }

        public boolean handleResourceMoved(Resource resource, URI newURI) {
            resource.unload();
            return true;
        }

        public boolean handleResourceChanged(Resource resource) {
            resource.unload();
            try {
                resource.load(resource.getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.emf.workspace.util.WorkspaceSynchronizer$DefaultDelegate");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.catching(clazz, "handleResourceChanged", e);
                EMFWorkspacePlugin.INSTANCE.log(e);
            }
            return true;
        }

        public void dispose() {
        }
    }

    public static interface Delegate {
        public boolean handleResourceDeleted(Resource var1);

        public boolean handleResourceMoved(Resource var1, URI var2);

        public boolean handleResourceChanged(Resource var1);

        public void dispose();
    }

    private static class ResourceSynchJob
    extends WorkspaceJob {
        private final List synchRequests;

        ResourceSynchJob(List synchRequests) {
            super(Messages.synchJobName);
            this.synchRequests = synchRequests;
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                Iterator iter = this.synchRequests.iterator();
                while (iter.hasNext()) {
                    ((SynchRequest)iter.next()).perform();
                }
            }
            catch (InterruptedException e) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.emf.workspace.util.WorkspaceSynchronizer$ResourceSynchJob");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.catching(clazz, "run", e);
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    private static class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                ArrayList synchRequests = new ArrayList();
                delta.accept(new IResourceDeltaVisitor(this, synchRequests){
                    final /* synthetic */ WorkspaceListener this$1;
                    private final /* synthetic */ List val$synchRequests;
                    {
                        this.this$1 = workspaceListener;
                        this.val$synchRequests = list;
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getFlags() != 131072 && delta.getResource().getType() == 1) {
                            switch (delta.getKind()) {
                                case 2: 
                                case 4: {
                                    WorkspaceListener.access$1(this.this$1, delta, this.val$synchRequests);
                                }
                            }
                        }
                        return true;
                    }
                });
                if (!synchRequests.isEmpty()) {
                    new ResourceSynchJob(synchRequests).schedule();
                }
            }
            catch (CoreException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.workspace.util.WorkspaceSynchronizer$WorkspaceListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.catching(clazz, "resourceChanged", e);
                EMFWorkspacePlugin.INSTANCE.log((Object)e);
            }
        }

        private void processDelta(IResourceDelta delta, List synchRequests) {
            Iterator iter = WorkspaceSynchronizer.getSynchronizers().iterator();
            while (iter.hasNext()) {
                ((WorkspaceSynchronizer)iter.next()).processDelta(delta, synchRequests);
            }
        }

        static /* synthetic */ void access$1(WorkspaceListener workspaceListener, IResourceDelta iResourceDelta, List list) {
            workspaceListener.processDelta(iResourceDelta, list);
        }
    }
}

