/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.commands;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateViewAndOptionallyElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;

public class CreateViewAndOptionallyElementCommandEx
extends CreateViewAndOptionallyElementCommand {
    private boolean xoffset;
    private boolean yoffset;

    public CreateViewAndOptionallyElementCommandEx(IAdaptable elementAdapter, IGraphicalEditPart containerEP, Point location, PreferencesHint preferencesHint, boolean offsetOnX, boolean offsetOnY) {
        super(elementAdapter, containerEP, location, preferencesHint);
        this.xoffset = offsetOnX;
        this.yoffset = offsetOnY;
    }

    protected View getExistingView(EObject element) {
        IGraphicalEditPart container = this.getContainerEP();
        while (!(container instanceof BpmnDiagramEditPart)) {
            container = (IGraphicalEditPart)container.getParent();
        }
        List pools = container.getChildren();
        for (IGraphicalEditPart gep : pools) {
            IGraphicalEditPart theTarget;
            if (!(gep instanceof PoolEditPart) || (theTarget = (IGraphicalEditPart)gep.findEditPart(null, element)) == null) continue;
            return (View)theTarget.getModel();
        }
        return null;
    }

    protected Point getLocation() {
        Dimension defaultDim;
        IElementType type = (IElementType)this.getElementAdapter().getAdapter(IElementType.class);
        if (type != null && !BpmnShapesDefaultSizes.DEFAULT_SIZE.equals((Object)(defaultDim = BpmnShapesDefaultSizes.getDefaultSize(type)))) {
            Point pt = super.getLocation().getCopy();
            if (this.yoffset) {
                pt.y -= defaultDim.height / 2;
            }
            if (this.xoffset) {
                pt.x -= defaultDim.width / 2;
            }
            return pt;
        }
        return super.getLocation();
    }
}

