/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Alerts;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PDPlugin
extends AbstractUIPlugin {
    private static final String ICONS_LIB_PATH = "icons";
    private static PDPlugin _plugin;
    private static Logger _log;
    private static Alerts _alerts;
    private ResourceBundle _resourceBundle;
    private Properties _properties;
    private URL _pluginBase;

    public PDPlugin() {
        _plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.jst.pagedesigner.JMTResources");
            _alerts = new Alerts((AbstractUIPlugin)this, this._resourceBundle);
            this._properties = new Properties();
            InputStream input = null;
            this._pluginBase = this.getBundle().getEntry("/");
            try {
                input = new URL(this._pluginBase, "default.properties").openStream();
                this._properties.load(input);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
            _log = new Logger(this.getBundle(), this._resourceBundle);
        }
        catch (Exception ee) {
            if (_log != null) {
                _log.error("log.msg", "Problems starting plug-in Web Application Development Common.", (Throwable)ee);
            }
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), 0, "Problems starting plug-in Web Application Development Common", (Throwable)ee));
        }
    }

    public static PDPlugin getDefault() {
        return _plugin;
    }

    public static Alerts getAlerts() {
        return _alerts;
    }

    public static Logger getLogger(Class theClass) {
        if (PDPlugin.getDefault() != null && PDPlugin.getDefault().getRootLogger() != null) {
            return PDPlugin.getDefault().getRootLogger();
        }
        return null;
    }

    public Logger getRootLogger() {
        return _log;
    }

    public static String getPluginId() {
        return PDPlugin.getDefault().getBundle().getSymbolicName();
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    public ResourceBundle getPluginDecriptorBundle() {
        return Platform.getResourceBundle((Bundle)PDPlugin.getDefault().getBundle());
    }

    public Properties getProperties() {
        return this._properties;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public Image getImage(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        Image image = images.get(name);
        if (image == null) {
            this.getImageDescriptor(name);
            image = images.get(name);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String name) {
        if (name == null) {
            return null;
        }
        ImageRegistry images = this.getImageRegistry();
        ImageDescriptor id = images.getDescriptor(name);
        if (id == null) {
            InputStream stream = null;
            try {
                URL url = new URL(this._pluginBase, "icons/" + name);
                stream = url.openStream();
                stream.close();
                id = ImageDescriptor.createFromURL((URL)url);
                images.put(name, id);
            }
            catch (IOException e1) {
                _log.info("Unable to create ImageDescriptor for: " + name, (Throwable)e1);
                return null;
            }
        }
        return id;
    }

    public InputStream readFile(String file) throws MalformedURLException, IOException {
        return new URL(this._pluginBase, file).openStream();
    }

    public File getFile(String file) throws MalformedURLException, IOException {
        return new File(new URL(this._pluginBase, file).getPath());
    }

    public static Path getInstallLocation() {
        try {
            URL url = PDPlugin.getDefault().getBundle().getEntry("/");
            String s1 = FileLocator.resolve((URL)url).getFile();
            if (s1.startsWith("/")) {
                s1 = s1.substring(1);
            }
            String s = (s1 = new Path(s1).toOSString()).endsWith(File.separator) ? s1 : String.valueOf(s1) + File.separator;
            return new Path(s);
        }
        catch (Exception exception) {
            _log.error("Error.PDPlugin.Installation.15", (Throwable)exception);
            return null;
        }
    }

    public static IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (PDPlugin.getDefault().getWorkbench() == null) {
            return null;
        }
        return PDPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PDPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PDPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = PDPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    public static Display getDisplay() {
        Shell shell = PDPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return Display.getDefault();
    }

    public static IProject getCurrentProject() {
        IProject curProject = null;
        IEditorPart editor = PDPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorInput input = editor.getEditorInput();
        IFile inputFile = null;
        if (input != null && input instanceof IFileEditorInput) {
            inputFile = ((IFileEditorInput)input).getFile();
            curProject = inputFile.getProject();
        }
        return curProject;
    }

    public static void log(IStatus status) {
        ILog log = PDPlugin.getDefault().getLog();
        log.log(status);
    }
}

