/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.StopServerJob;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class StopAction
extends AbstractServerAction {
    public StopAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionStop);
        this.setToolTipText(Messages.actionStopToolTip);
        this.setImageDescriptor(ImageResource.getImageDescriptor("IMG_ELCL_STOP"));
        this.setHoverImageDescriptor(ImageResource.getImageDescriptor("IMG_CLCL_STOP"));
        this.setDisabledImageDescriptor(ImageResource.getImageDescriptor("IMG_DLCL_STOP"));
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public boolean accept(IServer server) {
        if (server.getServerType() == null) {
            return false;
        }
        return server.getServerType() != null && server.canStop().isOK();
    }

    public void perform(IServer server) {
        ServerUIPlugin.addTerminationWatch(this.shell, server, 1);
        String name = NLS.bind((String)Messages.dialogStoppingServer, (Object)server.getName());
        StopServerJob stopJob = new StopServerJob(server, name);
        stopJob.schedule();
    }
}

