/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfiglModelSource;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;
import org.eclipse.osgi.util.NLS;

public class JSFLibraryConfigProjectData
implements JSFLibraryConfiglModelSource {
    static final String QUALIFIEDNAME = "org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData";
    protected static final String SPTR_TUPLE = ":";
    protected static final String EO_TUPLE = ";";
    private final IProject project;
    private final JSFLibraryRegistryUtil jsfLibReg;
    private JSFLibraryInternalReference selJSFLibImpl;
    private List selJSFLibComp;

    public JSFLibraryConfigProjectData(IProject project) {
        this.project = project;
        this.jsfLibReg = JSFLibraryRegistryUtil.getInstance();
        if (!this.isProjectFirstCreated()) {
            this.verifySavedLibAvailability();
        }
    }

    public IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE getImplementationType() {
        try {
            String type = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.type"));
            return IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.getValue(type);
        }
        catch (CoreException coreException) {
            return IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.UNKNOWN;
        }
    }

    public JSFLibraryInternalReference getJSFImplementationLibrary() {
        try {
            if (!this.isProjectFirstCreated() && this.selJSFLibImpl == null) {
                String strImplLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"));
                this.selJSFLibImpl = this.getJSFImplLibfromPersistentProperties(this.getTuples(strImplLibs));
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while returning reference to the JSF implementation library");
        }
        return this.selJSFLibImpl;
    }

    public List getJSFComponentLibraries() {
        try {
            if (!this.isProjectFirstCreated()) {
                if (this.selJSFLibComp == null) {
                    this.selJSFLibComp = new ArrayList();
                    String strCompLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.component.libraries"));
                    List savedList = this.getTuples(strCompLibs);
                    Iterator it = savedList.iterator();
                    Tuple crtTuple = null;
                    JSFLibraryInternalReference srcItem = null;
                    while (it.hasNext()) {
                        crtTuple = (Tuple)it.next();
                        srcItem = this.jsfLibReg.getJSFLibraryReferencebyID(crtTuple.getID());
                        if (srcItem == null) continue;
                        this.selJSFLibComp.add(new JSFLibraryInternalReference(srcItem.getLibrary(), true, crtTuple.needDeploy()));
                    }
                }
            } else {
                this.selJSFLibComp = new ArrayList(0);
            }
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while returning references to the JSF component libraries.");
        }
        return this.selJSFLibComp;
    }

    void saveData(List implementation, List component, IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE implType) {
        try {
            this.project.setPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"), this.generatePersistString(implementation));
            this.project.setPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.component.libraries"), this.generatePersistString(component));
            this.project.setPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.type"), IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE.getStringValue(implType));
            this.selJSFLibImpl = null;
            this.selJSFLibComp = null;
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while persisting the JSF Library preferences");
        }
    }

    private boolean isProjectFirstCreated() {
        boolean isNew = false;
        try {
            this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"));
        }
        catch (CoreException coreException) {
            isNew = true;
        }
        return isNew;
    }

    private void verifySavedLibAvailability() {
        try {
            String strImplLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.implementation.libraries"));
            String strCompLibs = this.project.getPersistentProperty(new QualifiedName(QUALIFIEDNAME, "jsf.component.libraries"));
            this.logMissingLib(this.getTuples(strImplLibs), true);
            this.logMissingLib(this.getTuples(strCompLibs), false);
        }
        catch (CoreException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Exception occured while verifying saved JSF Library preferences");
        }
    }

    private void logMissingLib(List jsfLibTuples, boolean isVerifyImpl) {
        if (this.jsfLibReg != null) {
            for (Tuple tuple : jsfLibTuples) {
                JSFLibraryInternalReference jsfLib = this.jsfLibReg.getJSFLibraryReferencebyID(tuple.getID());
                if (jsfLib != null) continue;
                String prjName = this.project.getName();
                String msg = isVerifyImpl ? Messages.JSFLibraryConfigPersistData_SAVED_IMPLLIB_NOT_FOUND : Messages.JSFLibraryConfigPersistData_SAVED_COMPLIB_NOT_FOUND;
                JSFCorePlugin.log(1, NLS.bind((String)msg, (Object)prjName));
            }
        }
    }

    private JSFLibraryInternalReference getJSFImplLibfromPersistentProperties(List jsfLibTuples) {
        if (this.jsfLibReg != null) {
            Tuple tuple2 = null;
            JSFLibraryInternalReference lib = null;
            for (Tuple tuple2 : jsfLibTuples) {
                lib = this.jsfLibReg.getJSFLibraryReferencebyID(tuple2.id);
                if (lib == null) continue;
                return new JSFLibraryInternalReference(lib.getLibrary(), tuple2.selected, tuple2.deploy);
            }
        }
        return null;
    }

    private String generatePersistString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            JSFLibraryInternalReference jsfLibItem = (JSFLibraryInternalReference)list.get(i);
            sb = sb.append(jsfLibItem.generatePersistString());
            sb.append(EO_TUPLE);
            ++i;
        }
        return sb.toString();
    }

    private List getTuples(String strJSFLibs) {
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        if (strJSFLibs != null) {
            String patternStr = EO_TUPLE;
            String[] fields = strJSFLibs.split(patternStr);
            if (strJSFLibs.length() > 0) {
                int i = 0;
                while (i < fields.length) {
                    Tuple tuple = new Tuple(fields[i]);
                    list.add(tuple);
                    ++i;
                }
            }
        }
        return list;
    }

    static class Tuple {
        private final String id;
        private final boolean selected;
        private final boolean deploy;

        Tuple(String id, boolean selected, boolean deploy) {
            this.id = id;
            this.selected = selected;
            this.deploy = deploy;
        }

        Tuple(String tuple) {
            String[] fields = tuple.split(JSFLibraryConfigProjectData.SPTR_TUPLE);
            if (fields.length < 3) {
                throw new IllegalStateException("Library registry is corrupt");
            }
            this.id = fields[0];
            this.selected = Boolean.valueOf(fields[1]);
            this.deploy = Boolean.valueOf(fields[2]);
        }

        String getID() {
            return this.id;
        }

        boolean isSelected() {
            return this.selected;
        }

        boolean needDeploy() {
            return this.deploy;
        }
    }
}

