/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.cst;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SimpleTypeEnum implements Enumerator
{
    IDENTIFIER_LITERAL(1, "identifier", "identifier"),
    SELF_LITERAL(2, "self", "self"),
    INTEGER_LITERAL(3, "Integer", "Integer"),
    STRING_LITERAL(4, "String", "String"),
    REAL_LITERAL(5, "Real", "Real"),
    BOOLEAN_LITERAL(6, "Boolean", "Boolean"),
    OCL_ANY_LITERAL(7, "OclAny", "OclAny"),
    OCL_VOID_LITERAL(8, "OclVoid", "OclVoid"),
    INVALID_LITERAL(9, "Invalid", "Invalid"),
    OCL_MESSAGE_LITERAL(10, "OclMessage", "OclMessage"),
    KEYWORD_LITERAL(11, "keyword", "keyword"),
    UNLIMITED_NATURAL_LITERAL(12, "UnlimitedNatural", "UnlimitedNatural");

    public static final int IDENTIFIER = 1;
    public static final int SELF = 2;
    public static final int INTEGER = 3;
    public static final int STRING = 4;
    public static final int REAL = 5;
    public static final int BOOLEAN = 6;
    public static final int OCL_ANY = 7;
    public static final int OCL_VOID = 8;
    public static final int INVALID = 9;
    public static final int OCL_MESSAGE = 10;
    public static final int KEYWORD = 11;
    public static final int UNLIMITED_NATURAL = 12;
    private static final SimpleTypeEnum[] VALUES_ARRAY;
    public static final List<SimpleTypeEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SimpleTypeEnum[]{IDENTIFIER_LITERAL, SELF_LITERAL, INTEGER_LITERAL, STRING_LITERAL, REAL_LITERAL, BOOLEAN_LITERAL, OCL_ANY_LITERAL, OCL_VOID_LITERAL, INVALID_LITERAL, OCL_MESSAGE_LITERAL, KEYWORD_LITERAL, UNLIMITED_NATURAL_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SimpleTypeEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SimpleTypeEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SimpleTypeEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SimpleTypeEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SimpleTypeEnum get(int value) {
        switch (value) {
            case 1: {
                return IDENTIFIER_LITERAL;
            }
            case 2: {
                return SELF_LITERAL;
            }
            case 3: {
                return INTEGER_LITERAL;
            }
            case 4: {
                return STRING_LITERAL;
            }
            case 5: {
                return REAL_LITERAL;
            }
            case 6: {
                return BOOLEAN_LITERAL;
            }
            case 7: {
                return OCL_ANY_LITERAL;
            }
            case 8: {
                return OCL_VOID_LITERAL;
            }
            case 9: {
                return INVALID_LITERAL;
            }
            case 10: {
                return OCL_MESSAGE_LITERAL;
            }
            case 11: {
                return KEYWORD_LITERAL;
            }
            case 12: {
                return UNLIMITED_NATURAL_LITERAL;
            }
        }
        return null;
    }

    private SimpleTypeEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

