/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.IPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.IJavaTypeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlBasic;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbedded;
import org.eclipse.jpt.core.internal.content.orm.XmlEmbeddedId;
import org.eclipse.jpt.core.internal.content.orm.XmlId;
import org.eclipse.jpt.core.internal.content.orm.XmlManyToMany;
import org.eclipse.jpt.core.internal.content.orm.XmlManyToOne;
import org.eclipse.jpt.core.internal.content.orm.XmlNullAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlOneToMany;
import org.eclipse.jpt.core.internal.content.orm.XmlOneToOne;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentAttribute;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlTransient;
import org.eclipse.jpt.core.internal.content.orm.XmlTypeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlVersion;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.GeneratorRepository;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaTypeContext;
import org.eclipse.jpt.core.internal.platform.MappingFileContext;
import org.eclipse.jpt.core.internal.platform.PersistenceUnitContext;
import org.eclipse.jpt.core.internal.platform.TypeContext;
import org.eclipse.jpt.core.internal.platform.XmlAttributeContext;
import org.eclipse.jpt.core.internal.platform.XmlBasicContext;
import org.eclipse.jpt.core.internal.platform.XmlEmbeddedContext;
import org.eclipse.jpt.core.internal.platform.XmlEmbeddedIdContext;
import org.eclipse.jpt.core.internal.platform.XmlIdContext;
import org.eclipse.jpt.core.internal.platform.XmlManyToManyContext;
import org.eclipse.jpt.core.internal.platform.XmlManyToOneContext;
import org.eclipse.jpt.core.internal.platform.XmlNullAttributeMappingContext;
import org.eclipse.jpt.core.internal.platform.XmlOneToManyContext;
import org.eclipse.jpt.core.internal.platform.XmlOneToOneContext;
import org.eclipse.jpt.core.internal.platform.XmlTransientContext;
import org.eclipse.jpt.core.internal.platform.XmlVersionContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlTypeContext
extends BaseContext
implements TypeContext {
    private XmlTypeMapping xmlTypeMapping;
    private JavaTypeContext javaTypeContext;
    private Collection<XmlAttributeContext> attributeMappingContexts;
    private Collection<XmlAttributeContext> virtualAttributeMappingContexts;
    private boolean refreshed;

    public XmlTypeContext(MappingFileContext parentContext, XmlTypeMapping xmlTypeMapping) {
        super(parentContext);
        this.xmlTypeMapping = xmlTypeMapping;
        this.attributeMappingContexts = new ArrayList<XmlAttributeContext>();
        this.virtualAttributeMappingContexts = new ArrayList<XmlAttributeContext>();
    }

    @Override
    public void initialize() {
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        PersistenceUnitContext puContext = this.getMappingFileContext().getPersistenceUnitContext();
        if (javaPersistentType != null) {
            if (puContext.containsDuplicateJavaPersistentType(javaPersistentType)) {
                return;
            }
            JavaTypeContext javaContext = (JavaTypeContext)this.getPlatform().buildJavaTypeContext(this, javaPersistentType.getMapping());
            XmlTypeContext duplicate = puContext.xmlTypeMappingContextFor(javaPersistentType.getMapping());
            if (duplicate != null) {
                duplicate.setDuplicateJavaTypeMapping();
                puContext.addDuplicateJpaFile(javaContext);
                return;
            }
            this.javaTypeContext = javaContext;
        }
        this.initializeAttributeMappingContexts();
    }

    protected void initializeAttributeMappingContexts() {
        for (XmlAttributeMapping xmlAttributeMapping : this.xmlTypeMapping.getPersistentType().getSpecifiedAttributeMappings()) {
            this.attributeMappingContexts.add(this.buildContext(xmlAttributeMapping));
        }
    }

    protected XmlAttributeContext buildContext(XmlAttributeMapping attributeMapping) {
        String key = attributeMapping.getKey();
        if (key == "id") {
            return new XmlIdContext((IContext)this, (XmlId)attributeMapping);
        }
        if (key == "basic") {
            return new XmlBasicContext((IContext)this, (XmlBasic)attributeMapping);
        }
        if (key == "oneToMany") {
            return new XmlOneToManyContext((IContext)this, (XmlOneToMany)attributeMapping);
        }
        if (key == "manyToOne") {
            return new XmlManyToOneContext((IContext)this, (XmlManyToOne)attributeMapping);
        }
        if (key == "manyToMany") {
            return new XmlManyToManyContext((IContext)this, (XmlManyToMany)attributeMapping);
        }
        if (key == "transient") {
            return new XmlTransientContext((IContext)this, (XmlTransient)attributeMapping);
        }
        if (key == "embedded") {
            return new XmlEmbeddedContext((IContext)this, (XmlEmbedded)attributeMapping);
        }
        if (key == "embeddedId") {
            return new XmlEmbeddedIdContext((IContext)this, (XmlEmbeddedId)attributeMapping);
        }
        if (key == "version") {
            return new XmlVersionContext((IContext)this, (XmlVersion)attributeMapping);
        }
        if (key == "oneToOne") {
            return new XmlOneToOneContext((IContext)this, (XmlOneToOne)attributeMapping);
        }
        if (key == null) {
            return new XmlNullAttributeMappingContext((IContext)this, (XmlNullAttributeMapping)attributeMapping);
        }
        throw new IllegalArgumentException(attributeMapping.toString());
    }

    protected void populateGeneratorRepository(GeneratorRepository generatorRepository) {
    }

    protected Collection<XmlAttributeContext> getXmlAttributeContexts() {
        return this.attributeMappingContexts;
    }

    protected MappingFileContext getMappingFileContext() {
        return (MappingFileContext)this.getParentContext();
    }

    protected XmlTypeMapping getXmlTypeMapping() {
        return this.xmlTypeMapping;
    }

    protected JavaTypeContext getJavaPersistentTypeContext() {
        return this.javaTypeContext;
    }

    protected IJavaTypeMapping getJavaTypeMapping() {
        if (this.javaTypeContext != null) {
            return this.javaTypeContext.getPersistentType().getMapping();
        }
        return null;
    }

    protected JavaPersistentType javaPersistentType() {
        return this.xmlTypeMapping.getPersistentType().findJavaPersistentType();
    }

    protected IJavaTypeMapping javaTypeMapping() {
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        if (javaPersistentType != null) {
            return javaPersistentType.getMapping();
        }
        return null;
    }

    public void setDuplicateJavaTypeMapping() {
        this.javaTypeContext = null;
    }

    public DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                return XmlTypeContext.this.getDefault(key, this.getWrappedDefaultsContext());
            }
        };
    }

    public DefaultsContext wrapDefaultsContextAstRoot(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public CompilationUnit astRoot() {
                return XmlTypeContext.this.javaTypeContext == null ? null : XmlTypeContext.this.javaTypeContext.getAstRoot();
            }
        };
    }

    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        return defaultsContext.getDefault(key);
    }

    @Override
    public XmlPersistentType getPersistentType() {
        return this.getXmlTypeMapping().getPersistentType();
    }

    @Override
    public boolean isRefreshed() {
        return this.refreshed;
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void refreshDefaults(DefaultsContext parentDefaults, IProgressMonitor monitor) {
        super.refreshDefaults(parentDefaults, monitor);
        this.refreshed = true;
        if (this.javaTypeContext != null) {
            this.javaTypeContext.refreshDefaults(parentDefaults, monitor);
        }
        DefaultsContext wrappedDefaultsContext = this.wrapDefaultsContextAstRoot(parentDefaults);
        this.refreshPersistentType(wrappedDefaultsContext, monitor);
        wrappedDefaultsContext = this.wrapDefaultsContext(wrappedDefaultsContext);
        this.refreshTableContext(wrappedDefaultsContext, monitor);
        this.xmlTypeMapping.refreshDefaults(wrappedDefaultsContext);
        this.refreshAttributeMappingContextDefaults(wrappedDefaultsContext, monitor);
    }

    protected void refreshTableContext(DefaultsContext defaultsContext, IProgressMonitor monitor) {
    }

    public void refreshAttributeMappingContextDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        for (XmlAttributeContext context : this.attributeMappingContexts) {
            this.checkCanceled(monitor);
            context.refreshDefaults(context.wrapDefaultsContext(defaultsContext), monitor);
        }
        for (XmlAttributeContext context : this.virtualAttributeMappingContexts) {
            this.checkCanceled(monitor);
            context.refreshDefaults(context.wrapDefaultsContext(defaultsContext), monitor);
        }
    }

    protected void refreshPersistentType(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        XmlPersistentType xmlPersistentType = this.getXmlTypeMapping().getPersistentType();
        xmlPersistentType.refreshDefaults(defaultsContext);
        Collection<IPersistentAttribute> javaAttributes = this.javaAttributes();
        ArrayList<Object> javaAttributeNames = new ArrayList<Object>();
        for (IPersistentAttribute javaAttribute : javaAttributes) {
            this.checkCanceled(monitor);
            String javaAttributeName = javaAttribute.getName();
            javaAttributeNames.add(javaAttributeName);
            XmlPersistentAttribute xmlAttribute = xmlPersistentType.attributeNamed(javaAttributeName);
            if (xmlAttribute == null) {
                this.createAndAddXmlAttributeFrom(javaAttribute, xmlPersistentType);
                continue;
            }
            if (!xmlAttribute.isVirtual()) continue;
            if (xmlAttribute.typeMapping().isXmlMetadataComplete()) {
                xmlAttribute.setSpecifiedMappingKey(javaAttribute.defaultMappingKey());
                continue;
            }
            xmlAttribute.setSpecifiedMappingKey(javaAttribute.mappingKey());
        }
        ArrayList<String> specifiedXmlAttributeNames = new ArrayList<String>();
        for (XmlPersistentAttribute specifiedAttribute : xmlPersistentType.getSpecifiedPersistentAttributes()) {
            this.checkCanceled(monitor);
            String attributeName = specifiedAttribute.getName();
            if (StringTools.stringIsEmpty((String)attributeName)) continue;
            specifiedXmlAttributeNames.add(attributeName);
        }
        ArrayList<XmlAttributeMapping> mappingsToRemove = new ArrayList<XmlAttributeMapping>();
        for (XmlAttributeMapping mapping : xmlPersistentType.getVirtualAttributeMappings()) {
            this.checkCanceled(monitor);
            String attributeName = mapping.getPersistentAttribute().getName();
            if (javaAttributeNames.contains(attributeName) && !specifiedXmlAttributeNames.contains(attributeName)) continue;
            mappingsToRemove.add(mapping);
        }
        for (XmlAttributeMapping xmlAttributeMapping : mappingsToRemove) {
            xmlPersistentType.getVirtualAttributeMappings().remove((Object)xmlAttributeMapping);
        }
        for (XmlAttributeMapping xmlAttributeMapping : this.xmlTypeMapping.getPersistentType().getVirtualAttributeMappings()) {
            this.virtualAttributeMappingContexts.add(this.buildContext(xmlAttributeMapping));
        }
    }

    private void createAndAddXmlAttributeFrom(IPersistentAttribute javaAttribute, XmlPersistentType persistentType) {
        XmlAttributeMapping xmlAttributeMapping = null;
        String mappingKey = persistentType.getMapping().isXmlMetadataComplete() ? javaAttribute.defaultMappingKey() : javaAttribute.getMapping().getKey();
        if (mappingKey == "basic") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlBasic();
        } else if (mappingKey == "id") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlId();
        } else if (mappingKey == "manyToMany") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlManyToMany();
        } else if (mappingKey == "manyToOne") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlManyToOne();
        } else if (mappingKey == "oneToMany") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlOneToMany();
        } else if (mappingKey == "transient") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlTransient();
        } else if (mappingKey == "embedded") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlEmbedded();
        } else if (mappingKey == "embeddedId") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlEmbeddedId();
        } else if (mappingKey == "version") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlVersion();
        } else if (mappingKey == "oneToOne") {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlOneToOne();
        } else if (mappingKey == null) {
            xmlAttributeMapping = OrmFactory.eINSTANCE.createXmlNullAttributeMapping();
        }
        persistentType.getVirtualAttributeMappings().add((Object)xmlAttributeMapping);
        xmlAttributeMapping.getPersistentAttribute().setName(javaAttribute.getName());
    }

    protected Collection<IPersistentAttribute> javaAttributes() {
        ArrayList<IPersistentAttribute> javaAttributes = new ArrayList<IPersistentAttribute>();
        JavaPersistentType javaPersistentType = this.javaPersistentType();
        if (javaPersistentType != null) {
            Iterator<JavaPersistentAttribute> i = javaPersistentType.attributes();
            while (i.hasNext()) {
                JavaPersistentAttribute persistentAttribute = i.next();
                javaAttributes.add(persistentAttribute);
            }
        }
        return javaAttributes;
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addClassMessages(messages);
        for (XmlAttributeContext context : this.attributeMappingContexts) {
            context.addToMessages(messages);
        }
        for (XmlAttributeContext context : this.virtualAttributeMappingContexts) {
            context.addToMessages(messages);
        }
    }

    protected void addClassMessages(List<IMessage> messages) {
        this.addUnspecifiedClassMessage(messages);
        this.addUnresolvedClassMessage(messages);
    }

    protected void addUnspecifiedClassMessage(List<IMessage> messages) {
        XmlPersistentType persistentType = this.xmlTypeMapping.getPersistentType();
        if (StringTools.stringIsEmpty((String)persistentType.getClass_())) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CLASS", persistentType, persistentType.classTextRange()));
        }
    }

    protected void addUnresolvedClassMessage(List<IMessage> messages) {
        XmlPersistentType persistentType = this.xmlTypeMapping.getPersistentType();
        if (!StringTools.stringIsEmpty((String)persistentType.getClass_()) && persistentType.findJdtType() == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{persistentType.getClass_()}, persistentType, persistentType.classTextRange()));
        }
    }
}

