/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.emf;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.ITechnologyFlavorLifecycle;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;

public abstract class DefaultScribblerDomain
implements IScribblerDomain {
    private final Map lifecycles = new HashMap();
    private ITechnologyFlavorLifecycle[] NO_LIFECYCLES;

    public boolean isContained(IResourceDescriptor aResourceDescriptor) {
        IResourceDescriptor[] descriptors = this.getResourceDescriptors();
        IPath filePath = aResourceDescriptor.getLocalPath();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getLocalPath().equals((Object)filePath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isContained(Resource aResource) {
        IFile file = WorkbenchResourceHelper.getFile(aResource);
        IResourceDescriptor[] descriptors = this.getResourceDescriptors();
        if (file != null) {
            IPath filePath = file.getFullPath();
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getLocalPath().equals((Object)filePath)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void addTechnologyFlavorLifecycle(ITechnologyFlavorLifecycle flavorManager) {
        this.lifecycles.put(flavorManager.getId(), flavorManager);
    }

    public ITechnologyFlavorLifecycle getTechnologyFlavorLifecycle(String technologyFlavorId) {
        return (ITechnologyFlavorLifecycle)this.lifecycles.get(technologyFlavorId);
    }

    public ITechnologyFlavorLifecycle[] getTechnologyFlavorLifecycles() {
        if (this.lifecycles.size() == 0) {
            return this.NO_LIFECYCLES;
        }
        return this.lifecycles.values().toArray(new ITechnologyFlavorLifecycle[this.lifecycles.size()]);
    }

    public boolean matches(IUndoContext context) {
        if (context instanceof IScribblerDomain) {
            IScribblerDomain otherDomain = (IScribblerDomain)context;
            return Arrays.equals(this.getResourceDescriptors(), otherDomain.getResourceDescriptors());
        }
        return false;
    }

    public String getLabel() {
        return this.getEditModelLabel();
    }
}

