/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emfworkbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.emf.workbench.EMFWorkbenchContextBase;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.stp.core.infrastructure.emf.EditModelEvent;
import org.eclipse.stp.core.infrastructure.emf.IEMFWorkbenchContext;
import org.eclipse.stp.core.infrastructure.emf.IEditModel;
import org.eclipse.stp.core.infrastructure.emf.IResourceAssistant;
import org.eclipse.stp.core.infrastructure.emf.WorkbenchResourceHelper;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.EditModel;
import org.eclipse.stp.core.internal.infrastructure.emf.ProjectResourceSetEditImpl;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.CompatibilityWorkbenchURIConverterImpl;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFResourceFactoryRegistry;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.EMFWorkbenchEditContextFactory;
import org.eclipse.stp.core.internal.infrastructure.emfworkbench.WorkspaceResourceHandler;

public class EMFWorkbenchContext
extends EMFWorkbenchContextBase
implements ISynchronizerExtender,
IEMFWorkbenchContext {
    private Map editableModels = new HashMap();
    protected Adapter resourceSetListener;
    private final Set managedResourceSets = new HashSet();
    private final Set assistants = new HashSet();
    public static final String RESOURCESET_ADAPTER_TYPE = ResourceSetListener.class.getName();

    public EMFWorkbenchContext(IProject aProject) {
        super(aProject);
        this.getResourceSet();
    }

    public static EMFWorkbenchContext getInstance(IProject aProject) {
        return (EMFWorkbenchContext)EMFWorkbenchEditContextFactory.sINSTANCE.createEMFContext(aProject, null);
    }

    public void connect(ResourceSet aResourceSet) {
        ResourceSetListener adapter;
        if (aResourceSet != null && (adapter = (ResourceSetListener)EcoreUtil.getAdapter((List)aResourceSet.eAdapters(), (Object)this)) == null) {
            this.managedResourceSets.add(aResourceSet);
            aResourceSet.eAdapters().add((Object)this.getResourceSetListener());
            if (this.shouldNotifyEditModels()) {
                EditModelEvent event = new EditModelEvent(4, (List)aResourceSet.getResources());
                this.notifyEditModels(event);
            }
        }
    }

    public void disconnect(ResourceSet aResourceSet) {
        ResourceSetListener adapter;
        if (aResourceSet != null && (adapter = (ResourceSetListener)EcoreUtil.getAdapter((List)aResourceSet.eAdapters(), (Object)this)) != null) {
            aResourceSet.eAdapters().remove((Object)this.getResourceSetListener());
            if (this.shouldNotifyEditModels()) {
                EditModelEvent event = new EditModelEvent(3, (List)aResourceSet.getResources());
                this.notifyEditModels(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installResourceAssistant(IResourceAssistant anAssistant) {
        EMFWorkbenchContext eMFWorkbenchContext = this;
        synchronized (eMFWorkbenchContext) {
            if (this.assistants.contains(anAssistant)) {
                return;
            }
            this.assistants.add(anAssistant);
            ResourceSet[] managedSets = anAssistant.getManagedResourceSets();
            if (managedSets != null) {
                int i = 0;
                while (i < managedSets.length) {
                    this.connect(managedSets[i]);
                    ++i;
                }
            }
            this.getResourceSet().addFirst((ResourceHandler)anAssistant);
        }
    }

    public void uninstallResourceHandler(IResourceAssistant anAssistant) {
        this.getResourceSet().remove((ResourceHandler)anAssistant);
    }

    public ProjectResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = (ProjectResourceSet)WorkbenchResourceHelper.getResourceSet((IProject)this.getProject());
            this.initializeResourceSet(this.resourceSet);
        }
        return this.resourceSet;
    }

    public ResourceSet[] getResourceSets() {
        return this.managedResourceSets.toArray(new ResourceSet[this.managedResourceSets.size()]);
    }

    protected void initializeResourceSet(ProjectResourceSet aResourceSet) {
        aResourceSet.setURIConverter((URIConverter)this.createURIConverter(aResourceSet));
        aResourceSet.add((ResourceHandler)new WorkspaceResourceHandler());
        aResourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)EMFResourceFactoryRegistry.sINSTANCE);
        aResourceSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
        this.startListeningToResourceSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEditModel getEditModel(String editModelID) {
        EMFWorkbenchContext eMFWorkbenchContext = this;
        synchronized (eMFWorkbenchContext) {
            IEditModel editModel = this.getExistingEditModel(editModelID);
            if (editModel == null || editModel.isDisposed()) {
                editModel = this.createEditModel(editModelID);
                this.cacheEditModel(editModel);
            }
            return editModel;
        }
    }

    protected IEditModel getExistingEditModel(String editModelID) {
        IEditModel editModel = null;
        editModel = (IEditModel)this.editableModels.get(editModelID);
        return editModel;
    }

    protected EditModel createEditModel(String editModelID) {
        return new EditModel(editModelID, this);
    }

    public void cacheEditModel(IEditModel editModel) {
        this.editableModels.put(editModel.getEditModelLabel(), editModel);
    }

    protected void discardAllEditModels() {
        this.discardModels(this.editableModels.values());
    }

    private void discardModels(Collection editModels) {
        if (editModels != null && !editModels.isEmpty()) {
            Iterator it = new ArrayList(editModels).iterator();
            while (it.hasNext()) {
                ((EditModel)it.next()).dispose();
            }
        }
    }

    public void removeEditModel(EditModel editModel, boolean readOnly) {
        this.editableModels.values().remove(editModel);
    }

    protected void notifyEditModels(EditModelEvent anEvent) {
        if (anEvent == null) {
            return;
        }
        ArrayList editModelsToNotify = new ArrayList(this.editableModels.values());
        int i = 0;
        while (i < editModelsToNotify.size()) {
            EditModel editModel = (EditModel)editModelsToNotify.get(i);
            try {
                editModel.resourceChanged(anEvent);
            }
            catch (Exception e) {
                EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, e.getMessage(), (Throwable)e));
            }
            ++i;
        }
    }

    protected boolean shouldNotifyEditModels() {
        return !this.editableModels.isEmpty();
    }

    protected Adapter getResourceSetListener() {
        if (this.resourceSetListener == null) {
            this.resourceSetListener = new ResourceSetListener();
        }
        return this.resourceSetListener;
    }

    private void addedResource(Resource addedResource) {
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(4, Collections.singletonList(addedResource));
            this.notifyEditModels(event);
        }
    }

    private void removedResource(Resource removedResource) {
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(3, Collections.singletonList(removedResource));
            this.notifyEditModels(event);
        }
    }

    private void removedResources(List removedResources) {
        if (this.shouldNotifyEditModels()) {
            EditModelEvent event = new EditModelEvent(3, removedResources);
            this.notifyEditModels(event);
        }
    }

    private void startListeningToResourceSet() {
        this.connect((ResourceSet)this.getResourceSet());
    }

    public void projectChanged(IResourceDelta delta) {
    }

    public void projectClosed() {
        this.discardAllEditModels();
        this.resourceSet = null;
        EMFWorkbenchEditContextFactory.sINSTANCE.removeCachedProject(this.getProject());
    }

    public WorkbenchURIConverter createURIConverter(ProjectResourceSet aResourceSet) {
        return new CompatibilityWorkbenchURIConverterImpl((IContainer)this.getProject(), aResourceSet.getSynchronizer());
    }

    public ProjectResourceSet createResourceSet() {
        if (this.project == null) {
            throw new IllegalStateException("Attempt to create resource set with null project");
        }
        return new ProjectResourceSetEditImpl(this.project);
    }

    public void deleteFile(Resource resource) {
        try {
            WorkbenchResourceHelper.deleteResource(resource);
        }
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
    }

    protected class ResourceSetListener
    extends AdapterImpl {
        protected ResourceSetListener() {
        }

        public boolean isAdapterForType(Object type) {
            return EMFWorkbenchContext.this == type;
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 3: {
                    EMFWorkbenchContext.this.addedResource((Resource)notification.getNewValue());
                    break;
                }
                case 4: {
                    EMFWorkbenchContext.this.removedResource((Resource)notification.getOldValue());
                    break;
                }
                case 6: {
                    EMFWorkbenchContext.this.removedResources((List)notification.getOldValue());
                }
            }
        }
    }
}

