/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IModule;

public class Tomcat32Handler
implements ITomcatVersionHandler {
    public IStatus verifyInstallPath(IPath installPath) {
        return TomcatPlugin.verifyInstallPath(installPath, "org.eclipse.jst.server.tomcat.32");
    }

    public String getRuntimeClass() {
        return "org.apache.tomcat.startup.Tomcat";
    }

    public List getRuntimeClasspath(IPath installPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        File libDir = installPath.append("lib").toFile();
        if (libDir.exists()) {
            String[] libs = libDir.list();
            int i = 0;
            while (i < libs.length) {
                if (libs[i].endsWith("jar")) {
                    IPath path = installPath.append("lib").append(libs[i]);
                    cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
                }
                ++i;
            }
        }
        return cp;
    }

    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (configPath != null) {
            list.add("-f \"" + configPath.append("conf").append("server.xml").toOSString() + "\"");
        }
        if (!starting) {
            list.add("-stop");
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public String[] getExcludedRuntimeProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("-Dtomcat.home=\"" + installPath.toOSString() + "\"");
        list.add("-Dwtp.deploy=\"" + deployPath.toOSString() + "\"");
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public String getRuntimePolicyFile(IPath configPath) {
        return configPath.append("conf").append("tomcat.policy").toOSString();
    }

    public IStatus canAddModule(IModule module) {
        if ("2.2".equals(module.getModuleType().getVersion())) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec32, null);
    }

    public IPath getRuntimeBaseDirectory(TomcatServer server) {
        return TomcatVersionHelper.getStandardBaseDirectory(server);
    }

    public IStatus prepareRuntimeDirectory(IPath confDir) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Preparing runtime directory");
        }
        if (!(temp = confDir.append("conf").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = confDir.append("webapps").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = confDir.append("work").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        return TomcatVersionHelper.createDeploymentDirectory(deployPath, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN\" \"http://java.sun.com/j2ee/dtds/web-app_2_2.dtd\">\n<web-app>\n</web-app>");
    }

    public IStatus prepareForServingDirectly(IPath baseDir, TomcatServer server) {
        if (server.isServeModulesWithoutPublish()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorNoPublishNotSupported, null);
        }
        return Status.OK_STATUS;
    }

    public String getSharedLoader(IPath baseDir) {
        return null;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return false;
    }

    public boolean supportsDebugArgument() {
        return true;
    }

    public boolean supportsSeparateContextFiles() {
        return false;
    }
}

