/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public final class ResourceSetManager {
    private static final ResourceSetManager INSTANCE = new ResourceSetManager();
    private final Map loadingResources = new WeakHashMap();
    private final Map loadedResources = new WeakHashMap();
    private final Map unloadingResources = new WeakHashMap();

    private ResourceSetManager() {
    }

    public static ResourceSetManager getInstance() {
        return INSTANCE;
    }

    public synchronized void observe(ResourceSet rset) {
        Iterator iter = rset.getResources().iterator();
        while (iter.hasNext()) {
            this.observe((Resource)iter.next());
        }
    }

    public synchronized void observe(ResourceSet rset, Notification notification) {
        if (notification.getFeatureID(null) == 0) {
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            switch (notification.getEventType()) {
                case 1: 
                case 2: {
                    if (newValue != null) {
                        this.observe((Resource)newValue);
                    }
                    if (oldValue == null) break;
                    this.setUnloaded((Resource)oldValue);
                    break;
                }
                case 3: {
                    if (newValue == null) break;
                    this.observe((Resource)newValue);
                    break;
                }
                case 5: {
                    if (newValue == null) break;
                    Iterator iter = ((Collection)newValue).iterator();
                    while (iter.hasNext()) {
                        this.observe((Resource)iter.next());
                    }
                    break;
                }
                case 4: {
                    if (oldValue == null) break;
                    this.setUnloaded((Resource)oldValue);
                    break;
                }
                case 6: {
                    if (oldValue == null) break;
                    Iterator iter = ((Collection)oldValue).iterator();
                    while (iter.hasNext()) {
                        this.setUnloaded((Resource)iter.next());
                    }
                    break;
                }
            }
        }
    }

    private synchronized void observe(Resource res) {
        if (res.isLoaded()) {
            this.setLoaded(res);
        } else {
            this.setUnloaded(res);
        }
    }

    public synchronized void observe(Resource res, Notification notification) {
        switch (notification.getFeatureID(null)) {
            case 4: {
                if (notification.getNewBooleanValue()) {
                    this.setLoaded(res);
                    break;
                }
                this.setUnloaded(res);
                break;
            }
            case 2: {
                if (!this.isLoaded(res) && res.isLoaded()) {
                    this.setLoading(res);
                    break;
                }
                if (!this.isLoaded(res) || res.isLoaded()) break;
                this.setUnloading(res);
            }
        }
    }

    public synchronized boolean isLoaded(Resource res) {
        return this.loadedResources.containsKey(res);
    }

    public synchronized boolean isLoading(Resource res) {
        return this.loadingResources.containsKey(res);
    }

    public synchronized boolean isUnloading(Resource res) {
        return this.unloadingResources.containsKey(res);
    }

    public synchronized boolean isUnloaded(Resource res) {
        return !this.isLoaded(res) && !this.isLoading(res) && !this.isUnloading(res);
    }

    private void setLoaded(Resource res) {
        this.loadedResources.put(res, Boolean.TRUE);
        this.loadingResources.remove(res);
        this.unloadingResources.remove(res);
    }

    private void setLoading(Resource res) {
        this.loadingResources.put(res, Boolean.TRUE);
        this.loadedResources.remove(res);
        this.unloadingResources.remove(res);
    }

    private void setUnloading(Resource res) {
        this.unloadingResources.put(res, Boolean.TRUE);
        this.loadedResources.remove(res);
        this.loadingResources.remove(res);
    }

    private void setUnloaded(Resource res) {
        this.loadedResources.remove(res);
        this.loadingResources.remove(res);
        this.unloadingResources.remove(res);
    }
}

