/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jpt.core.internal.mappings.ICascade;
import org.eclipse.jpt.core.internal.mappings.IRelationshipMapping;
import org.eclipse.jpt.ui.internal.details.BaseJpaComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CascadeComposite
extends BaseJpaComposite {
    private IRelationshipMapping relationshipMapping;
    private ICascade cascade;
    private Adapter relationshipMappingListener = this.buildRelationshipMappingListener();
    private Adapter cascadeListener = this.buildCascadeListener();
    private Button allCheckBox;
    private Button persistCheckBox;
    private Button mergeCheckBox;
    private Button removeCheckBox;
    private Button refreshCheckBox;

    public CascadeComposite(Composite parent, CommandStack commandStack, TabbedPropertySheetWidgetFactory widgetFactory) {
        super(parent, 0, commandStack, widgetFactory);
    }

    private Adapter buildRelationshipMappingListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                CascadeComposite.this.relationshipMappingChanged(notification);
            }
        };
    }

    private Adapter buildCascadeListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                CascadeComposite.this.cascadeChanged(notification);
            }
        };
    }

    protected void initializeLayout(Composite composite) {
        composite.setLayout((Layout)new FillLayout());
        Group cascadeGroup = this.getWidgetFactory().createGroup(composite, "Cascade");
        GridLayout layout = new GridLayout(5, false);
        cascadeGroup.setLayout((Layout)layout);
        this.allCheckBox = this.createAllCheckBox((Composite)cascadeGroup);
        GridData gridData = new GridData();
        this.allCheckBox.setLayoutData((Object)gridData);
        this.persistCheckBox = this.createPersistCheckBox((Composite)cascadeGroup);
        gridData = new GridData();
        this.persistCheckBox.setLayoutData((Object)gridData);
        this.mergeCheckBox = this.createMergeCheckBox((Composite)cascadeGroup);
        gridData = new GridData();
        this.mergeCheckBox.setLayoutData((Object)gridData);
        this.removeCheckBox = this.createRemoveCheckBox((Composite)cascadeGroup);
        gridData = new GridData();
        this.removeCheckBox.setLayoutData((Object)gridData);
        this.refreshCheckBox = this.createRefreshCheckBox((Composite)cascadeGroup);
        gridData = new GridData();
        this.refreshCheckBox.setLayoutData((Object)gridData);
    }

    private Button createAllCheckBox(Composite composite) {
        Button button = this.getWidgetFactory().createButton(composite, "All", 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadeComposite.this.allSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CascadeComposite.this.allSelected(e);
            }
        });
        return button;
    }

    protected void allSelected(SelectionEvent e) {
        boolean setSelection = this.initializeCascade();
        if (setSelection) {
            this.cascade.setAll(this.allCheckBox.getSelection());
        }
    }

    private boolean initializeCascade() {
        if (this.allCheckBoxesFalse() && this.cascade != null) {
            this.disengageCascadeListener();
            this.relationshipMapping.setCascade(null);
            return false;
        }
        if (this.cascade == null) {
            this.cascade = this.relationshipMapping.createCascade();
            this.relationshipMapping.setCascade(this.cascade);
            this.engageCascadeListener();
        }
        return true;
    }

    private Button createPersistCheckBox(Composite composite) {
        Button button = this.getWidgetFactory().createButton(composite, "Persist", 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadeComposite.this.persistSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CascadeComposite.this.persistSelected(e);
            }
        });
        return button;
    }

    protected void persistSelected(SelectionEvent e) {
        boolean setSelection = this.initializeCascade();
        if (setSelection) {
            this.cascade.setPersist(this.persistCheckBox.getSelection());
        }
    }

    private Button createMergeCheckBox(Composite composite) {
        Button button = this.getWidgetFactory().createButton(composite, "Merge", 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadeComposite.this.mergeSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CascadeComposite.this.mergeSelected(e);
            }
        });
        return button;
    }

    protected void mergeSelected(SelectionEvent e) {
        boolean setSelection = this.initializeCascade();
        if (setSelection) {
            this.cascade.setMerge(this.mergeCheckBox.getSelection());
        }
    }

    private Button createRemoveCheckBox(Composite composite) {
        Button button = this.getWidgetFactory().createButton(composite, "Remove", 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadeComposite.this.removeSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CascadeComposite.this.removeSelected(e);
            }
        });
        return button;
    }

    protected void removeSelected(SelectionEvent e) {
        boolean setSelection = this.initializeCascade();
        if (setSelection) {
            this.cascade.setRemove(this.removeCheckBox.getSelection());
        }
    }

    private Button createRefreshCheckBox(Composite composite) {
        Button button = this.getWidgetFactory().createButton(composite, "Refresh", 32);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CascadeComposite.this.refreshSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                CascadeComposite.this.refreshSelected(e);
            }
        });
        return button;
    }

    protected void refreshSelected(SelectionEvent e) {
        boolean setSelection = this.initializeCascade();
        if (setSelection) {
            this.cascade.setRefresh(this.refreshCheckBox.getSelection());
        }
    }

    private boolean allCheckBoxesFalse() {
        return !this.allCheckBox.getSelection() && !this.persistCheckBox.getSelection() && !this.mergeCheckBox.getSelection() && !this.removeCheckBox.getSelection() && !this.refreshCheckBox.getSelection();
    }

    private void relationshipMappingChanged(Notification notification) {
        if (notification.getFeatureID(IRelationshipMapping.class) == 4) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (CascadeComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    if (CascadeComposite.this.cascade != null) {
                        CascadeComposite.this.disengageCascadeListener();
                    }
                    CascadeComposite.this.cascade = CascadeComposite.this.relationshipMapping.getCascade();
                    CascadeComposite.this.populateCascade();
                    if (CascadeComposite.this.cascade != null) {
                        CascadeComposite.this.engageCascadeListener();
                    }
                }
            });
        }
    }

    private void cascadeChanged(final Notification notification) {
        switch (notification.getFeatureID(ICascade.class)) {
            case 0: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (CascadeComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        CascadeComposite.this.allCheckBox.setSelection(notification.getNewBooleanValue());
                    }
                });
                break;
            }
            case 1: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (CascadeComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        CascadeComposite.this.persistCheckBox.setSelection(notification.getNewBooleanValue());
                    }
                });
                break;
            }
            case 2: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (CascadeComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        CascadeComposite.this.mergeCheckBox.setSelection(notification.getNewBooleanValue());
                    }
                });
                break;
            }
            case 3: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (CascadeComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        CascadeComposite.this.removeCheckBox.setSelection(notification.getNewBooleanValue());
                    }
                });
                break;
            }
            case 4: {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (CascadeComposite.this.getControl().isDisposed()) {
                            return;
                        }
                        CascadeComposite.this.refreshCheckBox.setSelection(notification.getNewBooleanValue());
                    }
                });
                break;
            }
        }
        if (notification.getFeatureID(ICascade.class) == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (CascadeComposite.this.getControl().isDisposed()) {
                        return;
                    }
                    CascadeComposite.this.allCheckBox.setSelection(notification.getNewBooleanValue());
                }
            });
        }
    }

    public void doPopulate(EObject obj) {
        this.relationshipMapping = (IRelationshipMapping)obj;
        if (this.relationshipMapping != null) {
            this.cascade = this.relationshipMapping.getCascade();
            this.populateCascade();
        }
    }

    private void populateCascade() {
        if (this.cascade != null) {
            this.allCheckBox.setSelection(this.cascade.isAll());
            this.persistCheckBox.setSelection(this.cascade.isPersist());
            this.mergeCheckBox.setSelection(this.cascade.isMerge());
            this.removeCheckBox.setSelection(this.cascade.isRemove());
            this.refreshCheckBox.setSelection(this.cascade.isRefresh());
        } else {
            this.allCheckBox.setSelection(false);
            this.persistCheckBox.setSelection(false);
            this.mergeCheckBox.setSelection(false);
            this.removeCheckBox.setSelection(false);
            this.refreshCheckBox.setSelection(false);
        }
    }

    public void doPopulate() {
    }

    protected void engageListeners() {
        if (this.relationshipMapping != null) {
            this.relationshipMapping.eAdapters().add((Object)this.relationshipMappingListener);
            if (this.cascade != null) {
                this.engageCascadeListener();
            }
        }
    }

    protected void engageCascadeListener() {
        this.cascade.eAdapters().add((Object)this.cascadeListener);
    }

    protected void disengageCascadeListener() {
        this.cascade.eAdapters().remove((Object)this.cascadeListener);
    }

    protected void disengageListeners() {
        if (this.relationshipMapping != null) {
            this.relationshipMapping.eAdapters().remove((Object)this.relationshipMappingListener);
            if (this.cascade != null) {
                this.disengageCascadeListener();
            }
        }
    }
}

