/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ComboDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IStringButtonAdapter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringButtonDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ListEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedPropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.EditListEntriesDialog;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.EditMapEntriesDialog;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.EditValueDialog;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaBeanProperty;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaBeanUtils;
import org.eclipse.jst.jsf.facesconfig.ui.util.JavaClassUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddEditManagedPropertyDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 300;
    private static final int DEFAULT_CONTROL_WIDTH = 200;
    private ComboDialogField nameField;
    private ClassButtonDialogField classField;
    private ComboDialogField valueTypeField;
    private StringButtonDialogField valueField;
    private IProject project;
    private String propertyName;
    private String propertyClass;
    private String valueType;
    private Object valueObject;
    private ManagedBeanType managedBean;
    private List beanPropertyList;
    private ManagedPropertyType managedProperty;
    private Composite parent;
    public static final String[] valueTypes = new String[]{"value", "null-value", "map-entries", "list-entries"};
    private boolean isNew;
    private AbstractFacesConfigSection section;

    public AddEditManagedPropertyDialog(Shell parentShell, ManagedBeanType managedBean, AbstractFacesConfigSection section) {
        super(parentShell);
        this.isNew = true;
        this.managedBean = managedBean;
        this.section = section;
    }

    public AddEditManagedPropertyDialog(Shell parentShell, ManagedPropertyType managedProperty, AbstractFacesConfigSection section) {
        super(parentShell);
        this.isNew = false;
        this.managedProperty = managedProperty;
        this.managedBean = (ManagedBeanType)managedProperty.eContainer();
        this.section = section;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isNew) {
            newShell.setText(EditorMessages.AddEditManagedPropertyDialog_Add);
        } else {
            newShell.setText(EditorMessages.AddEditManagedPropertyDialog_Edit);
        }
    }

    protected Control createDialogArea(Composite parent_) {
        Composite container;
        this.parent = container = new Composite(parent_, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.nameField = new ComboDialogField(2060);
        this.nameField.setLabelText(EditorMessages.ManagedBeanPropertyEditDialog_PropertyName);
        int propertyCount = 0;
        this.beanPropertyList = this.getBeanPropertyList(this.managedBean);
        if (this.beanPropertyList != null) {
            propertyCount = this.beanPropertyList.size();
        }
        if (propertyCount > 0) {
            String[] propertyNames = new String[propertyCount];
            int i = 0;
            while (i < propertyCount) {
                JavaBeanProperty property = (JavaBeanProperty)this.beanPropertyList.get(i);
                propertyNames[i] = property.getName();
                ++i;
            }
            this.nameField.setItems(propertyNames);
        }
        this.nameField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedPropertyDialog.this.handleNameSelection(((ComboDialogField)field).getText());
            }
        });
        this.classField = new ClassButtonDialogField(null);
        this.classField.setProject(this.getProject());
        this.classField.setLabelText(EditorMessages.ManagedBeanPropertyEditDialog_PropertyClass);
        this.valueTypeField = new ComboDialogField(2060);
        this.valueTypeField.setLabelText(EditorMessages.ManagedBeanPropertyEditDialog_ValueType);
        this.valueTypeField.setItems(valueTypes);
        this.valueTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedPropertyDialog.this.updateValueStatus();
            }
        });
        this.valueField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddEditManagedPropertyDialog.this.handleChangeValue(AddEditManagedPropertyDialog.this.valueTypeField.getText(), ((StringButtonDialogField)field).getText());
            }
        });
        this.valueField.setLabelText(EditorMessages.ManagedBeanPropertyEditDialog_Value);
        this.valueField.setButtonLabel(EditorMessages.UI_Button_Edit_more);
        this.valueField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                AddEditManagedPropertyDialog.this.valueObject = ((StringButtonDialogField)field).getText();
            }
        });
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        int numberOfColumns = 5;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        container.setLayout((Layout)gl);
        this.nameField.doFillIntoGrid(null, container, numberOfColumns);
        LayoutUtil.setWidthHint((Control)this.nameField.getComboControl(null, container), (int)200);
        this.classField.doFillIntoGrid(null, container, numberOfColumns - 1);
        data = new GridData(4, 0x1000000, false, false);
        data.horizontalSpan = 2;
        this.classField.getChangeControl(null, container).setLayoutData((Object)data);
        LayoutUtil.setWidthHint((Control)this.classField.getTextControl(null, container), (int)200);
        this.valueTypeField.doFillIntoGrid(null, container, numberOfColumns);
        this.valueField.doFillIntoGrid(null, container, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.classField.getTextControl(null, container));
        this.valueTypeField.selectItem(0);
        if (!this.isNew && this.managedProperty != null) {
            this.initFields();
        }
        return container;
    }

    private void initFields() {
        if (this.managedProperty.getPropertyName() != null) {
            this.nameField.setText(this.managedProperty.getPropertyName().getTextContent());
        }
        if (this.managedProperty.getPropertyClass() != null) {
            this.classField.setText(this.managedProperty.getPropertyClass().getTextContent());
        }
        if (this.managedProperty.getValue() != null) {
            this.valueTypeField.setText(valueTypes[0]);
            this.valueField.setText(this.managedProperty.getValue().getTextContent());
        } else if (this.managedProperty.getNullValue() != null) {
            this.valueTypeField.setText(valueTypes[1]);
        } else if (this.managedProperty.getMapEntries() != null) {
            this.valueTypeField.setText(valueTypes[2]);
        } else if (this.managedProperty.getListEntries() != null) {
            this.valueTypeField.setText(valueTypes[3]);
        } else {
            this.valueTypeField.setText(valueTypes[0]);
        }
        this.updateValueStatus();
    }

    protected void handleNameSelection(String text) {
        int propertyCount = 0;
        if (this.beanPropertyList != null) {
            propertyCount = this.beanPropertyList.size();
        }
        if (propertyCount > 0) {
            int i = 0;
            while (i < propertyCount) {
                JavaBeanProperty property = (JavaBeanProperty)this.beanPropertyList.get(i);
                if (property.getName().equals(text.trim())) {
                    this.classField.setText(property.getQualifiedType());
                    break;
                }
                ++i;
            }
        }
    }

    private void updateValueStatus() {
        if (this.valueField == null) {
            return;
        }
        this.valueObject = null;
        if (this.valueTypeField.getText().equalsIgnoreCase("null-value")) {
            this.valueField.setEnabled(false);
            this.valueObject = FacesConfigFactory.eINSTANCE.createNullValueType();
        } else if (this.valueTypeField.getText().equalsIgnoreCase("map-entries") || this.valueTypeField.getText().equalsIgnoreCase("list-entries")) {
            this.valueField.getTextControl(null, this.parent).setEditable(false);
            this.valueField.setEnabled(true);
        } else {
            this.valueObject = "";
            this.valueField.getTextControl(null, this.parent).setEditable(true);
            this.valueField.setEnabled(true);
        }
    }

    protected void handleChangeValue(String valueType_, String value) {
        if (valueType_.equalsIgnoreCase("value")) {
            this.handleChangeLongStringValue(value);
        } else if (valueType_.equalsIgnoreCase("map-entries")) {
            this.handleChangeMapEntries();
        } else if (valueType_.equalsIgnoreCase("list-entries")) {
            this.handleChangeListEntries();
        }
    }

    private void handleChangeLongStringValue(String value) {
        EditValueDialog valueDialog = new EditValueDialog(EditorPlugin.getActiveShell(), value);
        if (valueDialog.open() == 0) {
            this.valueField.setText((String)valueDialog.getResultData());
            this.valueObject = valueDialog.getResultData();
        }
    }

    private void handleChangeMapEntries() {
        MapEntriesType mapEntries = this.valueObject instanceof MapEntriesType ? (MapEntriesType)this.valueObject : (this.isNew || this.managedProperty.getMapEntries() == null ? FacesConfigFactory.eINSTANCE.createMapEntriesType() : (MapEntriesType)EcoreUtil.copy((EObject)this.managedProperty.getMapEntries()));
        EditMapEntriesDialog dialog = new EditMapEntriesDialog(EditorPlugin.getActiveShell(), mapEntries, this.section);
        if (dialog.open() == 0) {
            this.valueObject = dialog.getMapEntries();
        } else if (!this.isNew && this.managedProperty.getMapEntries() != null) {
            this.valueObject = EcoreUtil.copy((EObject)this.managedProperty.getMapEntries());
        }
    }

    private void handleChangeListEntries() {
        ListEntriesType listEntries = this.valueObject instanceof ListEntriesType ? (ListEntriesType)this.valueObject : (this.isNew || this.managedProperty.getListEntries() == null ? FacesConfigFactory.eINSTANCE.createListEntriesType() : (ListEntriesType)EcoreUtil.copy((EObject)this.managedProperty.getListEntries()));
        EditListEntriesDialog dialog = new EditListEntriesDialog(EditorPlugin.getActiveShell(), listEntries, this.section);
        if (dialog.open() == 0) {
            this.valueObject = dialog.getListEntries();
        } else if (!this.isNew && this.managedProperty.getListEntries() != null) {
            this.valueObject = EcoreUtil.copy((EObject)this.managedProperty.getListEntries());
        }
    }

    private List getBeanPropertyList(ManagedBeanType managedBean_) {
        if (managedBean_.getManagedBeanClass() == null) {
            return null;
        }
        String beanClassName = managedBean_.getManagedBeanClass().getTextContent();
        IType classType = JavaClassUtils.getType(this.getProject(), beanClassName);
        if (classType == null) {
            return null;
        }
        ArrayList<JavaBeanProperty> list = new ArrayList<JavaBeanProperty>();
        JavaBeanProperty[] properties = JavaBeanUtils.getBeanProperties(classType);
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                list.add(properties[i]);
                ++i;
            }
        }
        return list;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(300), shellSize.x), shellSize.y);
    }

    public IProject getProject() {
        if (this.project == null) {
            this.project = (IProject)this.section.getPage().getEditor().getAdapter(IProject.class);
        }
        return this.project;
    }

    protected void okPressed() {
        this.propertyName = this.nameField.getText();
        this.propertyClass = this.classField.getText();
        this.valueType = this.valueTypeField.getText();
        super.okPressed();
    }

    public String getPropertyClass() {
        return this.propertyClass;
    }

    public void setAttributeClass(String attributeClass) {
        this.propertyClass = attributeClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setAttributeName(String attributeName) {
        this.propertyName = attributeName;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String defaultValue) {
        this.valueType = defaultValue;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public Object getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(Object valueObject) {
        this.valueObject = valueObject;
    }
}

