/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPageContainer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class DialogPage
extends org.eclipse.jface.dialogs.DialogPage
implements IDialogPage {
    private IDialogPageContainer mContainer;
    private boolean mIsValid = true;
    private boolean mIsModified = false;
    private boolean mNeedsApply = true;

    public DialogPage() {
    }

    public DialogPage(String title) {
        super(title);
    }

    public DialogPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean needsApplyButton() {
        return this.mNeedsApply;
    }

    public void setNeedsApplyButton(boolean needsApply) {
        this.mNeedsApply = needsApply;
    }

    public void setIsValid(boolean isValid) {
        this.mIsValid = isValid;
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    public void setIsModified(boolean isModified) {
        this.mIsModified = isModified;
        if (this.getContainer() != null) {
            this.getContainer().updateButtons();
        }
    }

    public abstract void createControl(Composite var1);

    public boolean isValid() {
        return this.mIsValid;
    }

    public boolean isModified() {
        return this.mIsModified;
    }

    public abstract boolean performOk();

    public boolean performApply() {
        boolean success = this.performOk();
        if (success) {
            this.setIsModified(false);
        }
        return success;
    }

    public boolean performCancel() {
        return true;
    }

    public IDialogPageContainer getContainer() {
        return this.mContainer;
    }

    public void setContainer(IDialogPageContainer container) {
        this.mContainer = container;
    }

    public void setDescription(String description) {
        super.setDescription(description);
        if (this.getContainer() != null) {
            this.getContainer().updateTitleBar();
        }
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }

    public void setMessage(String newMessage, int newType) {
        super.setMessage(newMessage, newType);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
        if (this.getContainer() != null) {
            this.getContainer().updateMessage();
        }
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.getContainer() != null) {
            this.getContainer().updateTitleBar();
        }
    }

    public void setImageDescriptor(ImageDescriptor image) {
    }

    public Image getImage() {
        Image image = super.getImage();
        if (image == null) {
            image = new Image((Device)Display.getCurrent(), 48, 48);
        }
        return image;
    }
}

