/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.util.test;

import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils {
    public static IProject getProject(String projectName) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            newProject = TestUtils.createProject(projectName, null);
        } else {
            try {
                newProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    public static IProject createProject(String projectName, IPath locationPath) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject theProject = root.getProject(projectName);
            IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(theProject.getName());
            if (locationPath != null && !Platform.getLocation().equals((Object)locationPath)) {
                description.setLocation(locationPath);
            }
            theProject.create(description, null);
            theProject.open(null);
            theProject.setDescription(description, null);
            return theProject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IFile addFileResourceToTestProject(IProject project, String localFileName, Class<?> testClass, String resourcePath) throws CoreException, IOException {
        TestUtils.checkFolder(project, localFileName);
        IFile newFile = project.getFile(localFileName);
        if (!newFile.exists()) {
            URL resourceWsdl = testClass.getResource(resourcePath);
            newFile.create(resourceWsdl.openStream(), true, null);
        }
        return newFile;
    }

    public static void checkFolder(IProject project, String path) throws CoreException {
        StringTokenizer token = new StringTokenizer(path, "/");
        int numOfToken = token.countTokens();
        if (numOfToken <= 1) {
            return;
        }
        IFolder folder = null;
        int i = 0;
        while (i < numOfToken - 1) {
            String onePath = (String)token.nextElement();
            IFolder childFolder = folder == null ? project.getFolder(onePath) : folder.getFolder(onePath);
            if (!childFolder.exists()) {
                childFolder.create(true, false, null);
            }
            folder = childFolder;
            ++i;
        }
    }
}

