/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.PlatformUI;

public class FileModificationValidator {
    private static FileModificationValidator INSTANCE = new FileModificationValidator();

    public static FileModificationValidator getInstance() {
        return INSTANCE;
    }

    private FileModificationValidator() {
    }

    public boolean okToEdit(IFile[] files, String modificationReason) {
        return this.okToEdit(files, modificationReason, null);
    }

    public boolean okToEdit(IFile[] files, final String modificationReason, Shell shell) {
        IStatus status;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && Display.getCurrent() != null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if ((status = ResourcesPlugin.getWorkspace().validateEdit(files, (Object)shell)).isOK()) {
            return true;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_EditProblemDialogTitle, (Object)modificationReason), (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_EditProblemDialogMessage, (Object)modificationReason, (Object)status.getMessage()));
            }
        });
        return false;
    }

    public boolean okToSave(IFile file) {
        IStatus status = null;
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)file.getProject());
        IFileModificationValidator validator = null;
        if (provider != null) {
            validator = provider.getFileModificationValidator();
        }
        if ((status = validator == null ? this.getDefaultStatus(file) : validator.validateSave(file)).isOK()) {
            return true;
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CommonUIMessages.FileModificationValidator_SaveProblemDialogTitle, (String)NLS.bind((String)CommonUIMessages.FileModificationValidator_SaveProblemDialogMessage, (Object)status.getMessage(), (Object)status.getMessage()));
        return false;
    }

    private IStatus getDefaultStatus(IFile file) {
        if (file.isReadOnly()) {
            String message = NLS.bind((String)CommonUIMessages.FileModificationValidator_FileIsReadOnlyErrorMessage, (Object)file.getFullPath().toString());
            return new Status(4, CommonUIPlugin.getPluginId(), 4, message, null);
        }
        return new Status(0, CommonUIPlugin.getPluginId(), 0, CommonUIMessages.FileModificationValidator_OK, null);
    }
}

