/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.gef.examples.text.edit.AbstractTextPart;
import org.eclipse.gef.examples.text.edit.BlockTextPart;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.figures.CommentPage;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;

public abstract class CompoundTextPart
extends AbstractTextPart {
    public CompoundTextPart(Object model) {
        this.setModel(model);
    }

    public boolean acceptsCaret() {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            TextEditPart part = (TextEditPart)iter.next();
            if (!part.acceptsCaret()) continue;
            return true;
        }
        return false;
    }

    public void activate() {
        super.activate();
        this.getContainer().getStyle().addPropertyChangeListener(this);
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        Object figure = null;
        switch (this.getContainer().getType()) {
            case 6: {
                figure = new InlineFlow();
                break;
            }
            case 2: {
                figure = new CommentPage();
                break;
            }
            case 4: {
                figure = new BlockFlow();
                figure.setBorder((Border)new MarginBorder(4, 2, 4, 0));
                break;
            }
            case 5: {
                figure = new FlowPage();
                figure.setBorder((Border)new MarginBorder(4));
                break;
            }
            default: {
                throw new RuntimeException("unexpected container");
            }
        }
        return figure;
    }

    public void deactivate() {
        this.getContainer().getStyle().removePropertyChangeListener(this);
        super.deactivate();
    }

    public CaretInfo getCaretPlacement(int offset, boolean trailing) {
        throw new RuntimeException("This part cannot place the caret");
    }

    protected Container getContainer() {
        return (Container)this.getModel();
    }

    public int getLength() {
        return this.getChildren().size();
    }

    protected List getModelChildren() {
        return this.getContainer().getChildren();
    }

    public void getTextLocation(CaretRequest search, SearchResult result) {
        if (search.getType() == CaretRequest.LINE_BOUNDARY) {
            if (search.isForward) {
                this.searchLineEnd(search, result);
            } else {
                this.searchLineBegin(search, result);
            }
        } else if (search.getType() == CaretRequest.ROW || search.getType() == CaretRequest.LOCATION) {
            if (search.isForward) {
                this.searchLineBelow(search, result);
            } else {
                this.searchLineAbove(search, result);
            }
        } else if (search.getType() == CaretRequest.COLUMN || search.getType() == CaretRequest.WORD_BOUNDARY) {
            if (search.isForward) {
                this.searchForward(search, result);
            } else {
                this.searchBackward(search, result);
            }
        } else if (this.getParent() instanceof TextEditPart) {
            this.getTextParent().getTextLocation(search, result);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("children")) {
            this.refreshChildren();
        }
    }

    protected void searchBackward(CaretRequest search, SearchResult result) {
        int childIndex = search.isRecursive ? this.getChildren().size() - 1 : this.getChildren().indexOf(search.where.part) - 1;
        boolean wasRecursive = search.isRecursive;
        search.setRecursive(true);
        while (childIndex >= 0) {
            TextEditPart part = (TextEditPart)this.getChildren().get(childIndex--);
            part.getTextLocation(search, result);
            if (result.location == null) continue;
            return;
        }
        search.setRecursive(wasRecursive);
        if (!search.isRecursive && this.getParent() instanceof TextEditPart) {
            if (this instanceof BlockTextPart) {
                search.isInto = true;
            }
            search.setReferenceTextLocation(this, 0);
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchForward(CaretRequest search, SearchResult result) {
        int childIndex = search.isRecursive ? 0 : this.getChildren().indexOf(search.where.part) + 1;
        int childCount = this.getChildren().size();
        boolean wasRecursive = search.isRecursive;
        search.setRecursive(true);
        while (childIndex < childCount) {
            TextEditPart part = (TextEditPart)this.getChildren().get(childIndex++);
            part.getTextLocation(search, result);
            if (result.location == null) continue;
            return;
        }
        search.setRecursive(wasRecursive);
        if (!search.isRecursive && this.getParent() instanceof TextEditPart) {
            if (this instanceof BlockTextPart) {
                search.isInto = true;
            }
            search.setReferenceTextLocation(this, this.getLength());
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchLineAbove(CaretRequest search, SearchResult result) {
        int childIndex;
        if (search.isRecursive) {
            childIndex = this.getChildren().size() - 1;
        } else {
            childIndex = this.getChildren().indexOf(search.where.part);
            if (search.where.offset == 0) {
                --childIndex;
            }
        }
        boolean wasRecursive = search.isRecursive;
        search.setRecursive(true);
        while (childIndex >= 0) {
            TextEditPart part = (TextEditPart)this.getChildren().get(childIndex--);
            part.getTextLocation(search, result);
            if (!result.bestMatchFound) continue;
            return;
        }
        search.setRecursive(wasRecursive);
        if (!search.isRecursive && this.getParent() instanceof TextEditPart) {
            search.setReferenceTextLocation(this, 0);
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchLineBegin(CaretRequest search, SearchResult result) {
        int childIndex = 0;
        int childCount = this.getChildren().size();
        search.setRecursive(true);
        while (childIndex < childCount) {
            TextEditPart newPart = (TextEditPart)this.getChildren().get(childIndex++);
            newPart.getTextLocation(search, result);
            if (result.location == null) continue;
            return;
        }
    }

    protected void searchLineBelow(CaretRequest search, SearchResult result) {
        int childIndex;
        int childCount = this.getChildren().size();
        if (search.isRecursive || !search.isRecursive && search.where == null) {
            childIndex = 0;
        } else {
            childIndex = this.getChildren().indexOf(search.where.part);
            if (search.where.offset == search.where.part.getLength()) {
                ++childIndex;
            }
        }
        boolean wasRecursive = search.isRecursive;
        search.setRecursive(true);
        while (childIndex < childCount) {
            TextEditPart part = (TextEditPart)this.getChildren().get(childIndex++);
            part.getTextLocation(search, result);
            if (!result.bestMatchFound) continue;
            return;
        }
        search.setRecursive(wasRecursive);
        if (!search.isRecursive && this.getParent() instanceof TextEditPart) {
            search.setReferenceTextLocation(this, this.getLength());
            this.getTextParent().getTextLocation(search, result);
        }
    }

    protected void searchLineEnd(CaretRequest search, SearchResult result) {
        int childIndex = this.getChildren().size() - 1;
        search.setRecursive(true);
        while (childIndex >= 0) {
            TextEditPart child = (TextEditPart)this.getChildren().get(childIndex--);
            child.getTextLocation(search, result);
            if (result.location == null) continue;
            return;
        }
    }
}

