/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.service.ClientContext;
import org.eclipse.emf.validation.internal.service.IClientContext;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.internal.util.XmlExpressionSelector;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.emf.validation.model.IModelConstraint;

public class ClientContextManager {
    private static final String E_CLIENT_CONTEXT = "clientContext";
    private static final String E_BINDING = "binding";
    private static final String A_CONTEXT = "context";
    private static final String A_CONSTRAINT = "constraint";
    private static final String A_CATEGORY = "category";
    private static final String A_REF = "ref";
    private static final ClientContextManager INSTANCE = new ClientContextManager();
    private final Set clientContexts = new HashSet();
    private final Map clientContextMap = new HashMap();
    private final Set defaultContexts = new HashSet();

    private ClientContextManager() {
    }

    public static final ClientContextManager getInstance() {
        return INSTANCE;
    }

    public IClientContext getClientContext(String contextId) {
        return (IClientContext)this.clientContextMap.get(contextId);
    }

    public Set getClientContexts() {
        return this.clientContexts;
    }

    public Collection getClientContextsFor(EObject eObject) {
        ArrayList<IClientContext> result = new ArrayList<IClientContext>();
        EvaluationContext ctx = new EvaluationContext(null, (Object)eObject);
        Iterator iter = this.getClientContexts().iterator();
        while (iter.hasNext()) {
            IClientContext next = (IClientContext)iter.next();
            IClientSelector selector = next.getSelector();
            EvaluationContext toTest = selector instanceof XmlExpressionSelector ? ctx : eObject;
            try {
                if (!selector.selects(toTest)) continue;
                result.add(next);
            }
            catch (RuntimeException e) {
                iter.remove();
                this.clientContextMap.remove(next.getId());
                this.defaultContexts.remove(next);
                Trace.catching(this.getClass(), "getClientContextsFor", e);
                Log.log(4, 114, EMFModelValidationPlugin.getMessage(ValidationMessages.client_selectorFailure_ERROR_, new Object[]{next.getId()}), e);
            }
        }
        return result;
    }

    public Collection getBindings(EObject eObject, Collection constraints) {
        Collection contexts = this.getClientContextsFor(eObject);
        Collection result = contexts.isEmpty() ? Collections.EMPTY_LIST : (contexts.size() == 1 ? this.getBindings((IClientContext)contexts.iterator().next(), constraints) : this.getBindings(contexts, constraints));
        return result;
    }

    public Collection getBindings(IClientContext context, Collection constraints) {
        ArrayList<IModelConstraint> result = new ArrayList<IModelConstraint>(constraints.size());
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            IModelConstraint constraint = (IModelConstraint)iter.next();
            if (context.includes(constraint)) {
                result.add(constraint);
                continue;
            }
            if (!context.isDefault() || !this.isDefaultBinding(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    public Collection getBindings(Collection contexts, Collection constraints) {
        ArrayList<IModelConstraint> result = new ArrayList<IModelConstraint>(constraints.size());
        IClientContext[] ctxArray = contexts.toArray(new IClientContext[contexts.size()]);
        boolean anyContextIsDefault = false;
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            IModelConstraint constraint = (IModelConstraint)iter.next();
            boolean bound = false;
            int i = 0;
            while (i < ctxArray.length) {
                bound = ctxArray[i].includes(constraint);
                if (bound) {
                    result.add(constraint);
                    break;
                }
                if (ctxArray[i].isDefault()) {
                    anyContextIsDefault = true;
                }
                ++i;
            }
            if (bound || !anyContextIsDefault || !this.isDefaultBinding(constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    private boolean isDefaultBinding(IModelConstraint constraint) {
        boolean result = true;
        String id = constraint.getDescriptor().getId();
        Iterator iter = this.clientContexts.iterator();
        while (result && iter.hasNext()) {
            boolean bl = result = !((IClientContext)iter.next()).includes(constraint);
        }
        if (result) {
            iter = this.defaultContexts.iterator();
            while (iter.hasNext()) {
                ((ClientContext)iter.next()).bindConstraint(id);
            }
        }
        return result;
    }

    public void configureConstraintBindings(IConfigurationElement[] elements) {
        this.configureClientContexts(elements);
        this.configureBindings(elements);
    }

    private void configureClientContexts(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement config = elements[i];
            if (E_CLIENT_CONTEXT.equals(config.getName())) {
                try {
                    ClientContext context = new ClientContext(config);
                    if (this.clientContexts.add(context)) {
                        this.clientContextMap.put(context.getId(), context);
                        if (context.isDefault()) {
                            this.defaultContexts.add(context);
                        }
                    }
                }
                catch (CoreException e) {
                    Trace.catching(this.getClass(), "configureClientContexts", e);
                    Log.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    private void configureBindings(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement config = elements[i];
            if (E_BINDING.equals(config.getName())) {
                String contextId = config.getAttribute(A_CONTEXT);
                if (contextId == null) {
                    Log.errorMessage(120, ValidationMessages.binding_noContextId_ERROR_, new Object[]{config.getDeclaringExtension().getNamespaceIdentifier()});
                } else {
                    ClientContext context = (ClientContext)this.getClientContext(contextId);
                    if (context == null) {
                        Log.errorMessage(121, ValidationMessages.binding_noSuchContext_ERROR_, new Object[]{contextId, config.getDeclaringExtension().getNamespaceIdentifier()});
                    } else {
                        this.configureBindings(context, config);
                    }
                }
            }
            ++i;
        }
    }

    private void configureBindings(ClientContext context, IConfigurationElement config) {
        String ref;
        String id = config.getAttribute(A_CONSTRAINT);
        if (id != null) {
            context.bindConstraint(id);
        }
        if ((id = config.getAttribute(A_CATEGORY)) != null) {
            context.bindCategory(id);
        }
        IConfigurationElement[] children = config.getChildren(A_CONSTRAINT);
        int i = 0;
        while (i < children.length) {
            ref = children[i].getAttribute(A_REF);
            if (ref == null) {
                Log.warningMessage(122, ValidationMessages.binding_noConstraintRef_WARN_, new Object[]{context.getId(), config.getDeclaringExtension().getNamespaceIdentifier()});
            } else {
                context.bindConstraint(ref);
            }
            ++i;
        }
        children = config.getChildren(A_CATEGORY);
        i = 0;
        while (i < children.length) {
            ref = children[i].getAttribute(A_REF);
            if (ref == null) {
                Log.errorMessage(123, ValidationMessages.binding_noCategoryRef_WARN_, new Object[]{context.getId(), config.getDeclaringExtension().getNamespaceIdentifier()});
            } else {
                context.bindCategory(ref);
            }
            ++i;
        }
    }
}

