/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.service.ITraversalStrategy;

class TraversalStrategyManager {
    private static final String TRAVERSAL_EXT_P_NAME = "traversal";
    private static final String E_TRAVERSAL_STRATEGY = "traversalStrategy";
    private static final String A_NAMESPACE_URI = "namespaceUri";
    private static final String A_CLASS = "class";
    private static final String E_ECLASS = "eclass";
    private static final String A_NAME = "name";
    private static final TraversalStrategyManager INSTANCE = new TraversalStrategyManager();
    private final Map packageDescriptors = new HashMap();

    private TraversalStrategyManager() {
        this.initStrategies();
    }

    public static TraversalStrategyManager getInstance() {
        return INSTANCE;
    }

    public ITraversalStrategy getTraversalStrategy(EObject eObject) {
        EObject root = EcoreUtil.getRootContainer((EObject)eObject);
        String nsUri = root.eClass().getEPackage().getNsURI();
        return this.getDescriptor(nsUri).getStrategy(root);
    }

    private void initStrategies() {
        IConfigurationElement[] strats = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFModelValidationPlugin.getPluginId(), TRAVERSAL_EXT_P_NAME);
        int i = 0;
        while (i < strats.length) {
            IConfigurationElement config = strats[i];
            if (config.getName().equals(E_TRAVERSAL_STRATEGY)) {
                this.addStrategy(config);
            }
            ++i;
        }
    }

    private void addStrategy(IConfigurationElement config) {
        String nsUri = config.getAttribute(A_NAMESPACE_URI);
        String className = config.getAttribute(A_CLASS);
        if (nsUri == null) {
            Log.warningMessage(100, EMFModelValidationStatusCodes.TRAVERSAL_NO_NAMESPACE_URI_MSG, new Object[]{config.getDeclaringExtension().getNamespaceIdentifier()});
        } else if (className == null) {
            Log.warningMessage(101, EMFModelValidationStatusCodes.TRAVERSAL_NO_CLASS_MSG, new Object[]{nsUri});
        } else {
            Descriptor descriptor = this.getDescriptor(nsUri);
            descriptor.addTraversalStrategy(config);
        }
    }

    private Descriptor getDescriptor(String nsUri) {
        Descriptor result = (Descriptor)this.packageDescriptors.get(nsUri);
        if (result == null) {
            result = new Descriptor(nsUri);
            this.packageDescriptors.put(nsUri, result);
        }
        return result;
    }

    private static class Descriptor {
        private final String nsUri;
        private Map eclassMap = new HashMap();
        private IConfigurationElement packageDefaultStrategyConfig;
        private ITraversalStrategy packageDefaultStrategy;
        private boolean isResolved;

        Descriptor(String nsUri) {
            this.nsUri = nsUri;
        }

        final String getNamespaceUri() {
            return this.nsUri;
        }

        public boolean equals(Object other) {
            return other instanceof Descriptor && this.getNamespaceUri().equals(((Descriptor)other).getNamespaceUri());
        }

        public int hashCode() {
            return this.getNamespaceUri().hashCode();
        }

        void addTraversalStrategy(IConfigurationElement config) {
            IConfigurationElement[] eclasses = config.getChildren(TraversalStrategyManager.E_ECLASS);
            if (eclasses.length == 0 && this.packageDefaultStrategyConfig == null) {
                this.packageDefaultStrategyConfig = config;
            } else {
                int i = 0;
                while (i < eclasses.length) {
                    IConfigurationElement next = eclasses[i];
                    String eclassName = next.getAttribute(TraversalStrategyManager.A_NAME);
                    if (!this.eclassMap.containsKey(eclassName)) {
                        this.eclassMap.put(eclassName, config);
                    }
                    ++i;
                }
            }
        }

        private void resolve(EPackage ePackage) {
            this.isResolved = true;
            HashMap newMap = new HashMap();
            Iterator iter = this.eclassMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                String eclassName = (String)next.getKey();
                EClassifier eclass = ePackage.getEClassifier(eclassName);
                if (eclass instanceof EClass) {
                    newMap.put(eclass, next.getValue());
                    continue;
                }
                Log.warningMessage(103, EMFModelValidationStatusCodes.TRAVERSAL_ECLASS_MSG, new Object[]{eclassName, ePackage.getNsURI()});
            }
            this.eclassMap = newMap;
        }

        ITraversalStrategy getStrategy(EObject eObject) {
            Object strategy;
            EClass eclass = eObject.eClass();
            if (!this.isResolved) {
                this.resolve(eclass.getEPackage());
            }
            if ((strategy = this.eclassMap.get(eclass)) == null) {
                strategy = this.inheritStrategy(eclass);
                this.eclassMap.put(eclass, strategy);
            }
            if (strategy instanceof ITraversalStrategy) {
                return (ITraversalStrategy)strategy;
            }
            return this.initializeStrategy((IConfigurationElement)strategy);
        }

        private Object inheritStrategy(EClass eclass) {
            Object result = this.getInheritedStrategy(eclass);
            if (result == null) {
                if (this.packageDefaultStrategy != null) {
                    result = this.packageDefaultStrategy;
                } else if (this.packageDefaultStrategyConfig != null) {
                    result = this.packageDefaultStrategyConfig;
                } else {
                    this.packageDefaultStrategy = new ITraversalStrategy.Recursive();
                    result = this.packageDefaultStrategy;
                }
            }
            return result;
        }

        private Object getInheritedStrategy(EClass eclass) {
            Object result = null;
            Iterator iter = eclass.getESuperTypes().iterator();
            while (result == null && iter.hasNext()) {
                EClass next = (EClass)iter.next();
                result = this.eclassMap.containsKey(next) ? this.eclassMap.get(next) : this.getInheritedStrategy(next);
            }
            return result;
        }

        private ITraversalStrategy initializeStrategy(IConfigurationElement config) {
            ITraversalStrategy result;
            try {
                result = (ITraversalStrategy)config.createExecutableExtension(TraversalStrategyManager.A_CLASS);
            }
            catch (ClassCastException classCastException) {
                Log.errorMessage(102, EMFModelValidationStatusCodes.TRAVERSAL_INTERFACE_MSG, new Object[]{config.getAttribute(TraversalStrategyManager.A_CLASS)});
                result = new ITraversalStrategy.Recursive();
            }
            catch (CoreException e) {
                Log.log(e.getStatus());
                result = new ITraversalStrategy.Recursive();
            }
            if (this.packageDefaultStrategyConfig == config) {
                this.packageDefaultStrategy = result;
            }
            Iterator iter = this.eclassMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                if (next.getValue() != config) continue;
                next.setValue(result);
            }
            return result;
        }
    }
}

