/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.ModelValidationService;

public final class ValidationEvent
extends EventObject {
    private static final long serialVersionUID = -7900125537603879206L;
    private final EvaluationMode mode;
    private final Map clientData;
    private final IStatus status;
    private final Collection targets;
    private List results;
    private Collection clientContextIds = null;

    public ValidationEvent(EvaluationMode mode, Map clientData, Collection targets, IStatus status) {
        super(ModelValidationService.getInstance());
        this.mode = mode;
        this.status = status;
        this.targets = Collections.unmodifiableCollection(targets);
        this.clientData = clientData == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(clientData);
    }

    public ValidationEvent(EvaluationMode mode, Map clientData, Collection targets, IStatus status, Collection clientContextIds) {
        this(mode, clientData, targets, status);
        this.clientContextIds = clientContextIds;
    }

    public Collection getClientContextIds() {
        if (this.clientContextIds == null) {
            this.clientContextIds = Collections.EMPTY_LIST;
        }
        return this.clientContextIds;
    }

    public EvaluationMode getEvaluationMode() {
        return this.mode;
    }

    public Map getClientData() {
        return this.clientData;
    }

    public Collection getValidationTargets() {
        return this.targets;
    }

    public int getSeverity() {
        return this.status.getSeverity();
    }

    public boolean matches(int severityMask) {
        return this.status.matches(severityMask);
    }

    public List getValidationResults() {
        if (this.results == null) {
            if (this.status.isMultiStatus()) {
                IStatus[] children = this.status.getChildren();
                this.results = new ArrayList(children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IConstraintStatus) {
                        this.results.add(children[i]);
                    }
                    ++i;
                }
                this.results = Collections.unmodifiableList(this.results);
            } else {
                this.results = this.status instanceof IConstraintStatus ? Collections.singletonList(this.status) : Collections.EMPTY_LIST;
            }
        }
        return this.results;
    }
}

