/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.query.internal.EMFQueryDebugOptions;

public final class EMFQueryPlugin
extends EMFPlugin {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    public static final EMFQueryPlugin INSTANCE = new EMFQueryPlugin();
    private static Implementation plugin;

    public EMFQueryPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static void catching(Class class1, String functionName, Throwable exception) {
        Tracing.catching(EMFQueryDebugOptions.EXCEPTIONS_CATCHING, class1, functionName, exception);
    }

    public static void throwing(Class class1, String functionName, Throwable exception) {
        Tracing.throwing(EMFQueryDebugOptions.EXCEPTIONS_THROWING, class1, functionName, exception);
    }

    public static void log(int code, String message, Throwable exception) {
        Status s = new Status(1, plugin.getSymbolicName(), code, message != null ? message : "", exception);
        EMFQueryPlugin.getPlugin().log(s);
    }

    public static void warning(int code, String message, Throwable exception) {
        Status s = new Status(2, plugin.getSymbolicName(), code, message != null ? message : "", exception);
        EMFQueryPlugin.getPlugin().log(s);
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }

    public static class Tracing {
        private static final Map cachedOptions = new HashMap();

        protected static boolean shouldTrace() {
            return plugin.isDebugging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean shouldTrace(String option) {
            if (Tracing.shouldTrace()) {
                Boolean value = null;
                Map map = cachedOptions;
                synchronized (map) {
                    value = (Boolean)cachedOptions.get(option);
                    if (value == null) {
                        value = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option)));
                        cachedOptions.put(option, value);
                    }
                }
                return value;
            }
            return false;
        }

        protected static String getArgumentString(Object argument) {
            return String.valueOf(argument);
        }

        protected static String getArgumentsString(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                buffer.append(Tracing.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(EMFQueryPlugin.SEPARATOR_PARAMETER);
                }
                ++i;
            }
            return buffer.toString();
        }

        public static void trace(String message) {
            if (Tracing.shouldTrace()) {
                System.out.println(message);
            }
        }

        public static void trace(String option, String message) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(message);
            }
        }

        public static void changing(String option, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_CHANGING + valueDescription + EMFQueryPlugin.SEPARATOR_SPACE + EMFQueryPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + EMFQueryPlugin.SEPARATOR_PARAMETER + EMFQueryPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue));
            }
        }

        public static void changing(String option, Class clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_CHANGING + valueDescription + EMFQueryPlugin.SEPARATOR_SPACE + EMFQueryPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + EMFQueryPlugin.SEPARATOR_PARAMETER + EMFQueryPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue) + EMFQueryPlugin.SEPARATOR_SPACE + EMFQueryPlugin.PARENTHESIS_OPEN + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void catching(String option, Class clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_CATCHING + throwable.getMessage() + EMFQueryPlugin.SEPARATOR_SPACE + EMFQueryPlugin.PARENTHESIS_OPEN + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void throwing(String option, Class clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_THROWING + throwable.getMessage() + EMFQueryPlugin.SEPARATOR_SPACE + EMFQueryPlugin.PARENTHESIS_OPEN + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void entering(String option, Class clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_ENTERING + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void entering(String option, Class clazz, String methodName, Object parameter) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_ENTERING + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.PARENTHESIS_OPEN + Tracing.getArgumentString(parameter) + EMFQueryPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void entering(String option, Class clazz, String methodName, Object[] parameters) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_ENTERING + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.PARENTHESIS_OPEN + Tracing.getArgumentsString(parameters) + EMFQueryPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void exiting(String option, Class clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_EXITING + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void exiting(String option, Class clazz, String methodName, Object returnValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(EMFQueryPlugin.PREFIX_EXITING + clazz.getName() + EMFQueryPlugin.SEPARATOR_METHOD + methodName + EMFQueryPlugin.SEPARATOR_RETURN + Tracing.getArgumentString(returnValue));
            }
        }
    }
}

