/******************************************************************************
 * Copyright (c) 2004, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/

package org.eclipse.gmf.runtime.notation.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.gmf.runtime.notation.util.NotationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class NotationItemProviderAdapterFactory extends NotationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

    /**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection supportedTypes = new ArrayList();

    /**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotationItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Edge} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EdgeItemProvider edgeItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Edge}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEdgeAdapter() {
		if (edgeItemProvider == null) {
			edgeItemProvider = new EdgeItemProvider(this);
		}

		return edgeItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Node} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeItemProvider nodeItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Node}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNodeAdapter() {
		if (nodeItemProvider == null) {
			nodeItemProvider = new NodeItemProvider(this);
		}

		return nodeItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FillStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FillStyleItemProvider fillStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FillStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFillStyleAdapter() {
		if (fillStyleItemProvider == null) {
			fillStyleItemProvider = new FillStyleItemProvider(this);
		}

		return fillStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.LineStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LineStyleItemProvider lineStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.LineStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createLineStyleAdapter() {
		if (lineStyleItemProvider == null) {
			lineStyleItemProvider = new LineStyleItemProvider(this);
		}

		return lineStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FontStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FontStyleItemProvider fontStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FontStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFontStyleAdapter() {
		if (fontStyleItemProvider == null) {
			fontStyleItemProvider = new FontStyleItemProvider(this);
		}

		return fontStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.TitleStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TitleStyleItemProvider titleStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.TitleStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createTitleStyleAdapter() {
		if (titleStyleItemProvider == null) {
			titleStyleItemProvider = new TitleStyleItemProvider(this);
		}

		return titleStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.SortingStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SortingStyleItemProvider sortingStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.SortingStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSortingStyleAdapter() {
		if (sortingStyleItemProvider == null) {
			sortingStyleItemProvider = new SortingStyleItemProvider(this);
		}

		return sortingStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DescriptionStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DescriptionStyleItemProvider descriptionStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DescriptionStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDescriptionStyleAdapter() {
		if (descriptionStyleItemProvider == null) {
			descriptionStyleItemProvider = new DescriptionStyleItemProvider(this);
		}

		return descriptionStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Size} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SizeItemProvider sizeItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Size}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSizeAdapter() {
		if (sizeItemProvider == null) {
			sizeItemProvider = new SizeItemProvider(this);
		}

		return sizeItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Location} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LocationItemProvider locationItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Location}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createLocationAdapter() {
		if (locationItemProvider == null) {
			locationItemProvider = new LocationItemProvider(this);
		}

		return locationItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Bounds} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BoundsItemProvider boundsItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Bounds}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBoundsAdapter() {
		if (boundsItemProvider == null) {
			boundsItemProvider = new BoundsItemProvider(this);
		}

		return boundsItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Ratio} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RatioItemProvider ratioItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Ratio}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRatioAdapter() {
		if (ratioItemProvider == null) {
			ratioItemProvider = new RatioItemProvider(this);
		}

		return ratioItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.IdentityAnchor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentityAnchorItemProvider identityAnchorItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.IdentityAnchor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIdentityAnchorAdapter() {
		if (identityAnchorItemProvider == null) {
			identityAnchorItemProvider = new IdentityAnchorItemProvider(this);
		}

		return identityAnchorItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.RoutingStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoutingStyleItemProvider routingStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.RoutingStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRoutingStyleAdapter() {
		if (routingStyleItemProvider == null) {
			routingStyleItemProvider = new RoutingStyleItemProvider(this);
		}

		return routingStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.RelativeBendpoints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelativeBendpointsItemProvider relativeBendpointsItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.RelativeBendpoints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createRelativeBendpointsAdapter() {
		if (relativeBendpointsItemProvider == null) {
			relativeBendpointsItemProvider = new RelativeBendpointsItemProvider(this);
		}

		return relativeBendpointsItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.CanonicalStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CanonicalStyleItemProvider canonicalStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.CanonicalStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createCanonicalStyleAdapter() {
		if (canonicalStyleItemProvider == null) {
			canonicalStyleItemProvider = new CanonicalStyleItemProvider(this);
		}

		return canonicalStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ShapeStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ShapeStyleItemProvider shapeStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ShapeStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createShapeStyleAdapter() {
		if (shapeStyleItemProvider == null) {
			shapeStyleItemProvider = new ShapeStyleItemProvider(this);
		}

		return shapeStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ConnectorStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorStyleItemProvider connectorStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ConnectorStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createConnectorStyleAdapter() {
		if (connectorStyleItemProvider == null) {
			connectorStyleItemProvider = new ConnectorStyleItemProvider(this);
		}

		return connectorStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Diagram} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiagramItemProvider diagramItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Diagram}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDiagramAdapter() {
		if (diagramItemProvider == null) {
			diagramItemProvider = new DiagramItemProvider(this);
		}

		return diagramItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Image} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageItemProvider imageItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Image}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createImageAdapter() {
		if (imageItemProvider == null) {
			imageItemProvider = new ImageItemProvider(this);
		}

		return imageItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.PageStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PageStyleItemProvider pageStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.PageStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPageStyleAdapter() {
		if (pageStyleItemProvider == null) {
			pageStyleItemProvider = new PageStyleItemProvider(this);
		}

		return pageStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DrawerStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DrawerStyleItemProvider drawerStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DrawerStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDrawerStyleAdapter() {
		if (drawerStyleItemProvider == null) {
			drawerStyleItemProvider = new DrawerStyleItemProvider(this);
		}

		return drawerStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.GuideStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuideStyleItemProvider guideStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.GuideStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGuideStyleAdapter() {
		if (guideStyleItemProvider == null) {
			guideStyleItemProvider = new GuideStyleItemProvider(this);
		}

		return guideStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.Guide} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuideItemProvider guideItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.Guide}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createGuideAdapter() {
		if (guideItemProvider == null) {
			guideItemProvider = new GuideItemProvider(this);
		}

		return guideItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeEntryItemProvider nodeEntryItemProvider;

    /**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNodeEntryAdapter() {
		if (nodeEntryItemProvider == null) {
			nodeEntryItemProvider = new NodeEntryItemProvider(this);
		}

		return nodeEntryItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.FilteringStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FilteringStyleItemProvider filteringStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.FilteringStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createFilteringStyleAdapter() {
		if (filteringStyleItemProvider == null) {
			filteringStyleItemProvider = new FilteringStyleItemProvider(this);
		}

		return filteringStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DiagramStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiagramStyleItemProvider diagramStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DiagramStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDiagramStyleAdapter() {
		if (diagramStyleItemProvider == null) {
			diagramStyleItemProvider = new DiagramStyleItemProvider(this);
		}

		return diagramStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ImageStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageStyleItemProvider imageStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ImageStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createImageStyleAdapter() {
		if (imageStyleItemProvider == null) {
			imageStyleItemProvider = new ImageStyleItemProvider(this);
		}

		return imageStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ImageBufferStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImageBufferStyleItemProvider imageBufferStyleItemProvider;

    /**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ImageBufferStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createImageBufferStyleAdapter() {
		if (imageBufferStyleItemProvider == null) {
			imageBufferStyleItemProvider = new ImageBufferStyleItemProvider(this);
		}

		return imageBufferStyleItemProvider;
	}

    /**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.PropertiesSetStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertiesSetStyleItemProvider propertiesSetStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.PropertiesSetStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPropertiesSetStyleAdapter() {
		if (propertiesSetStyleItemProvider == null) {
			propertiesSetStyleItemProvider = new PropertiesSetStyleItemProvider(this);
		}

		return propertiesSetStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringToPropertyValueMapEntryItemProvider stringToPropertyValueMapEntryItemProvider;

				/**
	 * This creates an adapter for a {@link java.util.Map.Entry}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStringToPropertyValueMapEntryAdapter() {
		if (stringToPropertyValueMapEntryItemProvider == null) {
			stringToPropertyValueMapEntryItemProvider = new StringToPropertyValueMapEntryItemProvider(this);
		}

		return stringToPropertyValueMapEntryItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.PropertyValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PropertyValueItemProvider propertyValueItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.PropertyValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createPropertyValueAdapter() {
		if (propertyValueItemProvider == null) {
			propertyValueItemProvider = new PropertyValueItemProvider(this);
		}

		return propertyValueItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.SingleValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SingleValueStyleItemProvider singleValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.SingleValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createSingleValueStyleAdapter() {
		if (singleValueStyleItemProvider == null) {
			singleValueStyleItemProvider = new SingleValueStyleItemProvider(this);
		}

		return singleValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ListValueStyleItemProvider listValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createListValueStyleAdapter() {
		if (listValueStyleItemProvider == null) {
			listValueStyleItemProvider = new ListValueStyleItemProvider(this);
		}

		return listValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.NamedStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedStyleItemProvider namedStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.NamedStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createNamedStyleAdapter() {
		if (namedStyleItemProvider == null) {
			namedStyleItemProvider = new NamedStyleItemProvider(this);
		}

		return namedStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DataTypeStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataTypeStyleItemProvider dataTypeStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DataTypeStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDataTypeStyleAdapter() {
		if (dataTypeStyleItemProvider == null) {
			dataTypeStyleItemProvider = new DataTypeStyleItemProvider(this);
		}

		return dataTypeStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.IntValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntValueStyleItemProvider intValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.IntValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIntValueStyleAdapter() {
		if (intValueStyleItemProvider == null) {
			intValueStyleItemProvider = new IntValueStyleItemProvider(this);
		}

		return intValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.IntListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntListValueStyleItemProvider intListValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.IntListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createIntListValueStyleAdapter() {
		if (intListValueStyleItemProvider == null) {
			intListValueStyleItemProvider = new IntListValueStyleItemProvider(this);
		}

		return intListValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.BooleanValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanValueStyleItemProvider booleanValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.BooleanValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBooleanValueStyleAdapter() {
		if (booleanValueStyleItemProvider == null) {
			booleanValueStyleItemProvider = new BooleanValueStyleItemProvider(this);
		}

		return booleanValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DoubleValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleValueStyleItemProvider doubleValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DoubleValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDoubleValueStyleAdapter() {
		if (doubleValueStyleItemProvider == null) {
			doubleValueStyleItemProvider = new DoubleValueStyleItemProvider(this);
		}

		return doubleValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DoubleListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DoubleListValueStyleItemProvider doubleListValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DoubleListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDoubleListValueStyleAdapter() {
		if (doubleListValueStyleItemProvider == null) {
			doubleListValueStyleItemProvider = new DoubleListValueStyleItemProvider(this);
		}

		return doubleListValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.StringValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringValueStyleItemProvider stringValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.StringValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStringValueStyleAdapter() {
		if (stringValueStyleItemProvider == null) {
			stringValueStyleItemProvider = new StringValueStyleItemProvider(this);
		}

		return stringValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.StringListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringListValueStyleItemProvider stringListValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.StringListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createStringListValueStyleAdapter() {
		if (stringListValueStyleItemProvider == null) {
			stringListValueStyleItemProvider = new StringListValueStyleItemProvider(this);
		}

		return stringListValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.EObjectValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EObjectValueStyleItemProvider eObjectValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.EObjectValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEObjectValueStyleAdapter() {
		if (eObjectValueStyleItemProvider == null) {
			eObjectValueStyleItemProvider = new EObjectValueStyleItemProvider(this);
		}

		return eObjectValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.EObjectListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EObjectListValueStyleItemProvider eObjectListValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.EObjectListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createEObjectListValueStyleAdapter() {
		if (eObjectListValueStyleItemProvider == null) {
			eObjectListValueStyleItemProvider = new EObjectListValueStyleItemProvider(this);
		}

		return eObjectListValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.ByteArrayValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ByteArrayValueStyleItemProvider byteArrayValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.ByteArrayValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createByteArrayValueStyleAdapter() {
		if (byteArrayValueStyleItemProvider == null) {
			byteArrayValueStyleItemProvider = new ByteArrayValueStyleItemProvider(this);
		}

		return byteArrayValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.BooleanListValueStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanListValueStyleItemProvider booleanListValueStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.BooleanListValueStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createBooleanListValueStyleAdapter() {
		if (booleanListValueStyleItemProvider == null) {
			booleanListValueStyleItemProvider = new BooleanListValueStyleItemProvider(this);
		}

		return booleanListValueStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HintedDiagramLinkStyleItemProvider hintedDiagramLinkStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.HintedDiagramLinkStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createHintedDiagramLinkStyleAdapter() {
		if (hintedDiagramLinkStyleItemProvider == null) {
			hintedDiagramLinkStyleItemProvider = new HintedDiagramLinkStyleItemProvider(this);
		}

		return hintedDiagramLinkStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.DiagramLinkStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DiagramLinkStyleItemProvider diagramLinkStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.DiagramLinkStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createDiagramLinkStyleAdapter() {
		if (diagramLinkStyleItemProvider == null) {
			diagramLinkStyleItemProvider = new DiagramLinkStyleItemProvider(this);
		}

		return diagramLinkStyleItemProvider;
	}

				/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.gmf.runtime.notation.MultiDiagramLinkStyle} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiDiagramLinkStyleItemProvider multiDiagramLinkStyleItemProvider;

				/**
	 * This creates an adapter for a {@link org.eclipse.gmf.runtime.notation.MultiDiagramLinkStyle}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter createMultiDiagramLinkStyleAdapter() {
		if (multiDiagramLinkStyleItemProvider == null) {
			multiDiagramLinkStyleItemProvider = new MultiDiagramLinkStyleItemProvider(this);
		}

		return multiDiagramLinkStyleItemProvider;
	}

				/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

    /**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

    /**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

    /**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

    /**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

    /**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

    /**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

    /**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (edgeItemProvider != null) edgeItemProvider.dispose();
		if (nodeItemProvider != null) nodeItemProvider.dispose();
		if (fillStyleItemProvider != null) fillStyleItemProvider.dispose();
		if (lineStyleItemProvider != null) lineStyleItemProvider.dispose();
		if (fontStyleItemProvider != null) fontStyleItemProvider.dispose();
		if (titleStyleItemProvider != null) titleStyleItemProvider.dispose();
		if (sortingStyleItemProvider != null) sortingStyleItemProvider.dispose();
		if (descriptionStyleItemProvider != null) descriptionStyleItemProvider.dispose();
		if (sizeItemProvider != null) sizeItemProvider.dispose();
		if (locationItemProvider != null) locationItemProvider.dispose();
		if (boundsItemProvider != null) boundsItemProvider.dispose();
		if (ratioItemProvider != null) ratioItemProvider.dispose();
		if (identityAnchorItemProvider != null) identityAnchorItemProvider.dispose();
		if (routingStyleItemProvider != null) routingStyleItemProvider.dispose();
		if (relativeBendpointsItemProvider != null) relativeBendpointsItemProvider.dispose();
		if (diagramItemProvider != null) diagramItemProvider.dispose();
		if (imageItemProvider != null) imageItemProvider.dispose();
		if (canonicalStyleItemProvider != null) canonicalStyleItemProvider.dispose();
		if (shapeStyleItemProvider != null) shapeStyleItemProvider.dispose();
		if (connectorStyleItemProvider != null) connectorStyleItemProvider.dispose();
		if (pageStyleItemProvider != null) pageStyleItemProvider.dispose();
		if (drawerStyleItemProvider != null) drawerStyleItemProvider.dispose();
		if (guideStyleItemProvider != null) guideStyleItemProvider.dispose();
		if (guideItemProvider != null) guideItemProvider.dispose();
		if (nodeEntryItemProvider != null) nodeEntryItemProvider.dispose();
		if (filteringStyleItemProvider != null) filteringStyleItemProvider.dispose();
		if (diagramStyleItemProvider != null) diagramStyleItemProvider.dispose();
		if (imageStyleItemProvider != null) imageStyleItemProvider.dispose();
		if (imageBufferStyleItemProvider != null) imageBufferStyleItemProvider.dispose();
		if (propertiesSetStyleItemProvider != null) propertiesSetStyleItemProvider.dispose();
		if (stringToPropertyValueMapEntryItemProvider != null) stringToPropertyValueMapEntryItemProvider.dispose();
		if (propertyValueItemProvider != null) propertyValueItemProvider.dispose();
		if (singleValueStyleItemProvider != null) singleValueStyleItemProvider.dispose();
		if (listValueStyleItemProvider != null) listValueStyleItemProvider.dispose();
		if (namedStyleItemProvider != null) namedStyleItemProvider.dispose();
		if (dataTypeStyleItemProvider != null) dataTypeStyleItemProvider.dispose();
		if (intValueStyleItemProvider != null) intValueStyleItemProvider.dispose();
		if (intListValueStyleItemProvider != null) intListValueStyleItemProvider.dispose();
		if (booleanValueStyleItemProvider != null) booleanValueStyleItemProvider.dispose();
		if (doubleValueStyleItemProvider != null) doubleValueStyleItemProvider.dispose();
		if (doubleListValueStyleItemProvider != null) doubleListValueStyleItemProvider.dispose();
		if (stringValueStyleItemProvider != null) stringValueStyleItemProvider.dispose();
		if (stringListValueStyleItemProvider != null) stringListValueStyleItemProvider.dispose();
		if (eObjectValueStyleItemProvider != null) eObjectValueStyleItemProvider.dispose();
		if (eObjectListValueStyleItemProvider != null) eObjectListValueStyleItemProvider.dispose();
		if (byteArrayValueStyleItemProvider != null) byteArrayValueStyleItemProvider.dispose();
		if (booleanListValueStyleItemProvider != null) booleanListValueStyleItemProvider.dispose();
		if (hintedDiagramLinkStyleItemProvider != null) hintedDiagramLinkStyleItemProvider.dispose();
		if (diagramLinkStyleItemProvider != null) diagramLinkStyleItemProvider.dispose();
		if (multiDiagramLinkStyleItemProvider != null) multiDiagramLinkStyleItemProvider.dispose();
	}

}
