/*******************************************************************************
* Copyright (c) 2006 Eclipse.org
* 
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*******************************************************************************/
package org.eclipse.gmf.internal.xpand.parser;

public interface XpandParsersym {
    public final static int
      TK_IDENT = 1,
      TK_STRING = 9,
      TK_INT_CONST = 19,
      TK_REAL_CONST = 20,
      TK_let = 27,
      TK_switch = 25,
      TK_implies = 41,
      TK_new = 21,
      TK_false = 22,
      TK_true = 23,
      TK_null = 24,
      TK_default = 42,
      TK_case = 43,
      TK_Collection = 3,
      TK_List = 4,
      TK_Set = 5,
      TK_typeSelect = 10,
      TK_collect = 11,
      TK_select = 12,
      TK_reject = 13,
      TK_exists = 14,
      TK_notExists = 15,
      TK_forAll = 16,
      TK_QUESTION_MARK = 44,
      TK_DCOLON = 28,
      TK_COLON = 30,
      TK_LPAREN = 2,
      TK_RPAREN = 6,
      TK_LCURLY = 17,
      TK_RCURLY = 32,
      TK_LSQUARE = 45,
      TK_RSQUARE = 46,
      TK_ARROW = 47,
      TK_NOT = 8,
      TK_AND = 48,
      TK_OR = 49,
      TK_ASSIGN = 50,
      TK_EQ = 51,
      TK_NE = 52,
      TK_GE = 53,
      TK_LE = 54,
      TK_GT = 55,
      TK_LT = 56,
      TK_PLUS = 57,
      TK_MINUS = 7,
      TK_MULTI = 29,
      TK_DIV = 58,
      TK_DOT = 34,
      TK_COMMA = 33,
      TK_BAR = 59,
      TK_IMPORT = 60,
      TK_EXTENSION = 61,
      TK_AROUND = 35,
      TK_ENDAROUND = 31,
      TK_DEFINE = 36,
      TK_ENDDEFINE = 37,
      TK_ERROR = 62,
      TK_EXPAND = 63,
      TK_FOR = 26,
      TK_SEPARATOR = 64,
      TK_AS = 38,
      TK_ITERATOR = 65,
      TK_FOREACH = 39,
      TK_ENDFOREACH = 66,
      TK_FILE = 67,
      TK_ENDFILE = 68,
      TK_IF = 69,
      TK_ELSEIF = 70,
      TK_ELSE = 71,
      TK_ENDIF = 72,
      TK_LET = 73,
      TK_ENDLET = 74,
      TK_PROTECT = 75,
      TK_CSTART = 76,
      TK_CEND = 77,
      TK_ID = 78,
      TK_DISABLE = 79,
      TK_ENDPROTECT = 80,
      TK_LG = 81,
      TK_EOF_TOKEN = 40,
      TK_TEXT = 18,
      TK_ERROR_TOKEN = 82;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "IDENT",
                 "LPAREN",
                 "Collection",
                 "List",
                 "Set",
                 "RPAREN",
                 "MINUS",
                 "NOT",
                 "STRING",
                 "typeSelect",
                 "collect",
                 "select",
                 "reject",
                 "exists",
                 "notExists",
                 "forAll",
                 "LCURLY",
                 "TEXT",
                 "INT_CONST",
                 "REAL_CONST",
                 "new",
                 "false",
                 "true",
                 "null",
                 "switch",
                 "FOR",
                 "let",
                 "DCOLON",
                 "MULTI",
                 "COLON",
                 "ENDAROUND",
                 "RCURLY",
                 "COMMA",
                 "DOT",
                 "AROUND",
                 "DEFINE",
                 "ENDDEFINE",
                 "AS",
                 "FOREACH",
                 "EOF_TOKEN",
                 "implies",
                 "default",
                 "case",
                 "QUESTION_MARK",
                 "LSQUARE",
                 "RSQUARE",
                 "ARROW",
                 "AND",
                 "OR",
                 "ASSIGN",
                 "EQ",
                 "NE",
                 "GE",
                 "LE",
                 "GT",
                 "LT",
                 "PLUS",
                 "DIV",
                 "BAR",
                 "IMPORT",
                 "EXTENSION",
                 "ERROR",
                 "EXPAND",
                 "SEPARATOR",
                 "ITERATOR",
                 "ENDFOREACH",
                 "FILE",
                 "ENDFILE",
                 "IF",
                 "ELSEIF",
                 "ELSE",
                 "ENDIF",
                 "LET",
                 "ENDLET",
                 "PROTECT",
                 "CSTART",
                 "CEND",
                 "ID",
                 "DISABLE",
                 "ENDPROTECT",
                 "LG",
                 "ERROR_TOKEN"
             };

    public final static boolean isValidForParser = true;
}
