/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELTranslatorException;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;

public class ScopeStack {
    int SCOPEID = 0;
    Util compiler_util;
    Stack scopes = new Stack();
    int LOGICAL = 1;

    public ScopeStack(Util compiler_util) {
        this.compiler_util = compiler_util;
    }

    public void pushScope(String idFetchString, boolean isolated, Node source) throws BPELTranslatorException {
        this.pushScope(idFetchString, isolated, source, false);
    }

    public void pushScope(String idFetchString, boolean isolated, Node source, boolean ignoreParentIsolation) throws BPELTranslatorException {
        Scope scope = new Scope();
        scope.name = "\"+" + idFetchString + "+\"S" + this.SCOPEID++;
        scope.isolated = isolated;
        scope.logicalStart = this.LOGICAL++;
        if (isolated && !ignoreParentIsolation) {
            int i = 0;
            while (i < this.scopes.size()) {
                Scope tmp = (Scope)this.scopes.get(i);
                if (tmp.isolated) {
                    throw new BPELTranslatorException(this.compiler_util, source, "Cannot nest isolated scopes (this scope has a parent which is also isolated)");
                }
                ++i;
            }
        }
        this.scopes.push(scope);
    }

    public void popScope(Node source) throws BPELTranslatorException {
        if (this.scopes.isEmpty()) {
            throw new BPELTranslatorException(this.compiler_util, source, "Tried to pop scope, but was already at maximum");
        }
        Scope tmp = (Scope)this.scopes.pop();
        tmp.logicalEnd = this.LOGICAL++;
    }

    public int getScopeLogicalStart() throws BPELTranslatorException {
        return ((Scope)this.scopes.peek()).logicalStart;
    }

    public int getScopeLogicalEnd() throws BPELTranslatorException {
        return this.LOGICAL;
    }

    public String[] getIsolatedVariableNames(Node source) throws BPELTranslatorException {
        if (this.scopes.isEmpty()) {
            throw new BPELTranslatorException(this.compiler_util, source, "Tried to get isolated variable names for scope but was already at maximum");
        }
        Scope scope = (Scope)this.scopes.peek();
        ArrayList names = new ArrayList(scope.isolatedVariables.keySet());
        String[] array = new String[names.size()];
        names.toArray(array);
        return array;
    }

    public void addVariable(String name, String qtype) {
        Scope scope = (Scope)this.scopes.peek();
        scope.variables.put(name, qtype);
    }

    public String getVariableName(String name, Node source) throws BPELTranslatorException {
        Scope owner = null;
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            Scope scope = (Scope)this.scopes.get(i);
            if (scope.variables.get(name) != null) {
                owner = scope;
                break;
            }
            if (scope.isolated) {
                scope.isolatedVariables.put(name, name);
            }
            --i;
        }
        if (owner != null) {
            return String.valueOf(owner.name) + ":" + name;
        }
        throw new BPELTranslatorException(this.compiler_util, source, "variable \"" + name + "\" not found in any enclosing scope");
    }

    public String getVariableQtype(String name, Node source) throws BPELTranslatorException {
        Object qtype = null;
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            Scope scope = (Scope)this.scopes.get(i);
            if (qtype == null && (qtype = scope.variables.get(name)) != null) {
                if (!scope.isolated) break;
                scope.isolatedVariables.put(name, name);
                break;
            }
            --i;
        }
        if (qtype != null) {
            return qtype;
        }
        throw new BPELTranslatorException(this.compiler_util, source, "variable \"" + name + "\" not found in any enclosing scope");
    }

    public void addCorrelationSet(String name, String[] qproperties) {
        Scope scope = (Scope)this.scopes.peek();
        scope.correlationSets.put(name, qproperties);
    }

    public String getCorrelationSetName(String name, Node source) throws BPELTranslatorException {
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            Scope scope = (Scope)this.scopes.get(i);
            Object test = scope.correlationSets.get(name);
            if (test != null) {
                return String.valueOf(scope.name) + ":" + name;
            }
            --i;
        }
        throw new BPELTranslatorException(this.compiler_util, source, "correlation set \"" + name + "\" not found in any enclosing scope");
    }

    public String[] getCorrelationSetProperties(String name, Node source) throws BPELTranslatorException {
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            Scope scope = (Scope)this.scopes.get(i);
            Object properties = scope.correlationSets.get(name);
            if (properties != null) {
                return (String[])properties;
            }
            --i;
        }
        throw new BPELTranslatorException(this.compiler_util, source, "correlation set \"" + name + "\" not found in any enclosing scope");
    }

    public void addLink(String name) {
        Scope scope = (Scope)this.scopes.peek();
        scope.links.put(name, name);
    }

    public String getLinkName(String name, Node source) throws BPELTranslatorException {
        Scope scope;
        int i = this.scopes.size() - 1;
        while (i >= 0) {
            scope = (Scope)this.scopes.get(i);
            Object test = scope.links.get(name);
            if (test != null) {
                return String.valueOf(scope.name) + ":" + name;
            }
            --i;
        }
        i = 0;
        while (i < this.scopes.size()) {
            System.out.println(this.scopes.get(i));
            scope = (Scope)this.scopes.get(i);
            for (String key : scope.links.keySet()) {
                System.out.println("  " + key + " = " + scope.links.get(key));
            }
            ++i;
        }
        throw new BPELTranslatorException(this.compiler_util, source, "link \"" + name + "\" not found in any enclosing flow");
    }

    class Scope {
        String name = "SCOPE_ERROR";
        boolean isolated;
        HashMap variables = new HashMap();
        HashMap links = new HashMap();
        HashMap correlationSets = new HashMap();
        HashMap isolatedVariables = new HashMap();
        int logicalStart;
        int logicalEnd;

        Scope() {
        }

        public String toString() {
            return this.name;
        }
    }
}

