/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.core.bpel;

import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;

public class WSEndpointReference {
    String address;
    ArrayList ref_properties = new ArrayList();
    String port_type;
    String service_name;
    String service_port;
    ArrayList policies = new ArrayList();

    private WSEndpointReference() {
    }

    public WSEndpointReference(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public static WSEndpointReference fromXML(String xml) throws Exception {
        WSEndpointReference epr = new WSEndpointReference();
        CharStack cs = new CharStack(xml);
        String elem_epr = cs.popXmlElementStart();
        if (!elem_epr.endsWith("EndpointReference")) {
            throw new Exception("expected tag 'EndpointReference', instead found '" + elem_epr + "'");
        }
        cs.popXmlElementEnd();
        while (true) {
            String elem;
            if ((elem = cs.popXmlElementStart()).endsWith("Address")) {
                cs.popXmlAttributes();
                cs.popXmlElementEnd();
                epr.address = cs.popXmlText(true, true);
            } else if (elem.endsWith("ServiceName")) {
                String attr = cs.popXmlAttributeName();
                while (attr.length() > 0) {
                    if (attr.equals("PortName")) {
                        epr.service_port = cs.popXmlAttributeValue();
                    } else {
                        cs.popXmlAttributeValue();
                    }
                    attr = cs.popXmlAttributeName();
                }
                cs.popXmlElementEnd();
                epr.service_name = cs.popXmlText(true);
            } else if (elem.endsWith("PortType")) {
                cs.popXmlAttributes();
                cs.popXmlElementEnd();
                epr.port_type = cs.popXmlText(true);
            } else if (elem.endsWith("ReferenceProperties")) {
                cs.popXmlAttributes();
                cs.popXmlElementEnd();
                epr.ref_properties.add(cs.popXmlSubTree(true));
            } else {
                if (elem.endsWith("EndpointReference") && elem.startsWith("/")) break;
                cs.popXmlAttributes();
                cs.popXmlElementEnd();
            }
            cs.popXmlElementStart();
            cs.popXmlElementEnd();
        }
        cs.popXmlElementEnd();
        return epr;
    }

    public static String toXML(WSEndpointReference epr) {
        StringBuffer sb = new StringBuffer();
        sb.append("<wsa:EndpointReference xlmns:wsa=\"").append("http://schemas.xmlsoap.org/ws/2004/03/addressing").append("\">");
        sb.append("<wsa:Address>").append(epr.address).append("</wsa:Address>");
        if (epr.port_type != null) {
            sb.append("<wsa:PortType>").append(epr.port_type).append("</wsa:PortType>");
        }
        if (epr.service_name != null) {
            if (epr.service_port != null) {
                sb.append("<wsa:ServiceName>").append(epr.service_name).append("</wsa:ServiceName>");
            } else {
                sb.append("<wsa:ServiceName ");
                sb.append("PortName=\"");
                sb.append(epr.service_port);
                sb.append("\" >");
                sb.append(epr.service_name);
                sb.append("</wsa:ServiceName>");
            }
        }
        int i = 0;
        while (i < epr.ref_properties.size()) {
            sb.append("<wsa:ReferenceProperties>");
            sb.append((String)epr.ref_properties.get(i));
            sb.append("</wsa:ReferenceProperties>");
            ++i;
        }
        sb.append("</wsa:EndpointReference>");
        return sb.toString();
    }

    public String toString() {
        return WSEndpointReference.toXML(this);
    }

    public static void main(String[] args) {
        try {
            System.out.println(WSEndpointReference.fromXML("<EndpointReference xmlns=\"http://schemas.xmlsoap.org/ws/2004/03/addressing\" ><!--LINENO file (Scapa Merged Choreography BPEL) line 43 --><Address ><!--LINENO file (Scapa Merged Choreography BPEL) line 43 -->http://localhost:30291/</Address></EndpointReference>"));
            StringBuffer sb = new StringBuffer();
            sb.append("<EndpointReference>");
            sb.append("<Address>blah</Address>");
            sb.append("</EndpointReference>");
            System.out.println(WSEndpointReference.fromXML(sb.toString()));
            sb = new StringBuffer();
            sb.append("<EndpointReference>");
            sb.append("<Address>myAddress</Address>");
            sb.append("<PortType>myPortType</PortType>");
            sb.append("<ServiceName PortName=\"myPortName\">myServiceName</ServiceName>");
            sb.append("<ReferenceProperties>aaaa<bbbb>cccc</bbbb>dddd</ReferenceProperties>");
            sb.append("</EndpointReference>");
            System.out.println(WSEndpointReference.fromXML(sb.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

