/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;

public class DataTransfer {
    private static final byte INTEGER = 1;
    private static final byte SHORT = 2;
    private static final byte BYTE = 3;
    private static final byte DOUBLE = 4;
    private static final byte FLOAT = 5;
    private static final byte BYTES = 6;
    private static final byte STRING = 7;
    private static final byte LONG = 8;

    private DataTransfer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeObject(Object o, OutputStream bout) throws IllegalArgumentException, IOException {
        if (o instanceof Number) {
            Number n = (Number)o;
            if (o instanceof Integer) {
                bout.write(1);
                StreamUtils.writeInt(bout, n.intValue());
                return;
            } else if (o instanceof Long) {
                bout.write(8);
                StreamUtils.writeLong(bout, n.longValue());
                return;
            } else if (o instanceof Double) {
                bout.write(4);
                StreamUtils.writeDouble(bout, n.doubleValue());
                return;
            } else if (o instanceof Short) {
                bout.write(2);
                StreamUtils.writeShort(bout, n.shortValue());
                return;
            } else if (o instanceof Float) {
                bout.write(5);
                StreamUtils.writeFloat(bout, n.floatValue());
                return;
            } else {
                if (!(o instanceof Byte)) throw new IllegalArgumentException("unserializable argument " + o);
                bout.write(3);
                bout.write(n.byteValue());
            }
            return;
        } else if (o instanceof byte[]) {
            bout.write(6);
            StreamUtils.writeBytes(bout, (byte[])o);
            return;
        } else {
            if (!(o instanceof String)) throw new IllegalArgumentException("unserializable argument " + o);
            bout.write(7);
            StreamUtils.writeString(bout, (String)o);
        }
    }

    public static byte[] serialise(ArrayList args) throws IllegalArgumentException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.reset();
        StreamUtils.writeInt(bout, args.size());
        int i = 0;
        while (i < args.size()) {
            DataTransfer.writeObject(args.get(i), bout);
            ++i;
        }
        return bout.toByteArray();
    }

    public static byte[] serialise(Object[] args) throws IllegalArgumentException, IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamUtils.writeInt(bout, args.length);
        int i = 0;
        while (i < args.length) {
            DataTransfer.writeObject(args[i], bout);
            ++i;
        }
        return bout.toByteArray();
    }

    public static ArrayList deserialise(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        return DataTransfer.deserialise(bin);
    }

    public static ArrayList deserialise(InputStream bin) throws IOException {
        ArrayList<Object> args = new ArrayList<Object>();
        int count = StreamUtils.readInt(bin);
        int i = 0;
        while (i < count) {
            int t = bin.read();
            byte b = (byte)t;
            Logger.info(String.valueOf(t) + " " + b);
            switch (b) {
                case 1: {
                    args.add(new Integer(StreamUtils.readInt(bin)));
                    break;
                }
                case 7: {
                    args.add(StreamUtils.readNString(bin, 100000000));
                    break;
                }
                case 6: {
                    args.add(StreamUtils.readNBytes(bin, 100000000));
                    break;
                }
                case 8: {
                    args.add(new Long(StreamUtils.readLong(bin)));
                    break;
                }
                case 4: {
                    args.add(new Double(StreamUtils.readDouble(bin)));
                    break;
                }
                case 2: {
                    args.add(new Short(StreamUtils.readShort(bin)));
                    break;
                }
                case 3: {
                    args.add(new Byte((byte)bin.read()));
                    break;
                }
                case 5: {
                    args.add(new Float(StreamUtils.readFloat(bin)));
                    break;
                }
                default: {
                    throw new IOException("unrecognised deserialisation type " + b);
                }
            }
            t = bin.read();
            ++i;
        }
        return args;
    }
}

