/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.engine;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.api.BpelProgramFactory;
import org.eclipse.stp.b2j.core.jengine.internal.api.EngineFactory;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.utils.EngineListenerTraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TraceListenerTranslatorLog;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.importresolver.StandardWsdlImportResolver;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.WorkbenchJDTJavaCompiler;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.eclipse.stp.b2j.core.ui.internal.debug.ControllerDebugTarget;
import org.osgi.framework.Bundle;

public class WorkbenchBPELEngine {
    BPELProgram program;
    Object running_LOCK = new Object();
    boolean running = false;
    ControllerInterface controller = null;
    Message root_runner_ids = null;
    IDebugTarget debugTarget = null;

    public IDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    public WorkbenchBPELEngine(BPELProgram program) {
        this.program = program;
    }

    public void runProgram() throws Exception {
        this.runProgram(new IgnoredTraceListener(), false, false, true, true);
    }

    public void runProgram(boolean useMiniEngine, boolean terminateEngineOnDisconnect) throws Exception {
        this.runProgram(new IgnoredTraceListener(), false, false, useMiniEngine, terminateEngineOnDisconnect);
    }

    public void runProgram(boolean debug, boolean verbose, boolean useMiniEngine, boolean terminateEngineOnDisconnect) throws Exception {
        this.runProgram(new IgnoredTraceListener(), debug, verbose, useMiniEngine, terminateEngineOnDisconnect);
    }

    public void runProgram(BPELEngineListener listener, boolean debug, boolean verbose, boolean useMiniEngine, boolean terminateEngineOnDisconnect) throws Exception {
        this.runProgram(listener, debug, verbose, useMiniEngine, terminateEngineOnDisconnect, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runProgram(BPELEngineListener listener, boolean debug, boolean verbose, boolean useMiniEngine, boolean terminateEngineOnDisconnect, ILaunch launch) throws Exception {
        Object object = this.running_LOCK;
        synchronized (object) {
            this.runInternal(listener, debug, verbose, useMiniEngine, terminateEngineOnDisconnect, this.program, launch, false);
        }
    }

    public void terminate() throws Exception {
        this.controller.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForProgramCompletion() throws Exception {
        Object object = this.running_LOCK;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            int i = 0;
            while (i < this.root_runner_ids.length()) {
                Long id = (Long)this.root_runner_ids.get(i);
                this.controller.joinRunner(id);
                ++i;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            this.controller.closeConnection();
            this.running = false;
            this.debugTarget = null;
        }
    }

    public void validateProgram() throws Exception {
        this.runInternal(new IgnoredTraceListener(), false, false, true, true, this.program, null, true);
    }

    private void runInternal(BPELEngineListener console, boolean debug, boolean verbose, boolean useMiniEngine, boolean exitOnDisconnect, BPELProgram bpel_program, ILaunch launch, boolean validateOnly) throws Exception {
        long t;
        EngineListenerTraceListener console_tracel = new EngineListenerTraceListener(console);
        long tott = System.currentTimeMillis();
        ArrayList program_deps = this.fetchAllProgramDependencies(console);
        Program prog = null;
        try {
            JARDependency[] tmp_program_deps = this.dependencyListToArray(program_deps);
            long t2 = System.currentTimeMillis();
            console.printInfo("Generating engine program...");
            Switches switches = new Switches();
            if (debug) {
                switches.FLOW_GRAPH_ASSET_OPTIMISATION = false;
                switches.SINGLE_HOST_ASSET_OPTIMISATION = false;
                switches.MAP_XSDTYPE_TO_INDEXMAP = false;
                switches.RICH_ENGINE_SERIALISATION = true;
            }
            console.printInfo("");
            TraceListenerTranslatorLog mclog = new TraceListenerTranslatorLog(console_tracel, verbose);
            prog = BpelProgramFactory.createEngineProgramFromBpelSource(debug, switches, new WorkbenchJDTJavaCompiler(), new StandardWsdlImportResolver(), bpel_program.getBaseURI(), bpel_program.getBpelSource(), tmp_program_deps, mclog, validateOnly, useMiniEngine);
            console.printInfo("");
            t2 = System.currentTimeMillis() - t2;
            console.printInfo("Generated engine program (" + (t2 /= 1000L) + "sec)");
            console.printInfo("");
            if (validateOnly) {
                return;
            }
        }
        catch (Exception e) {
            if (validateOnly) {
                throw e;
            }
            this.printFatalProblem(console, "Failed to build engine program from BPEL source", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to build engine program from BPEL source", false);
            return;
        }
        SessionAddress[] workers = bpel_program.getWorkerHosts();
        SessionAddress[] worker_daemons = bpel_program.getWorkerDaemons();
        int i = 0;
        while (i < workers.length) {
            prog.addHostAddress(workers[i], worker_daemons[i]);
            ++i;
        }
        ArrayList engine_deps = this.fetchAllEngineDependencies(console);
        int i2 = 0;
        while (i2 < program_deps.size()) {
            JARDependency dep = (JARDependency)program_deps.get(i2);
            int k = 0;
            while (k < engine_deps.size()) {
                JARDependency tmp = (JARDependency)engine_deps.get(k);
                if (dep.getFilePath().equals(tmp.getFilePath())) {
                    program_deps.remove(i2--);
                    break;
                }
                ++k;
            }
            ++i2;
        }
        JARDependency[] engine_deps_array = this.dependencyListToArray(engine_deps);
        JARDependency[] program_deps_array = this.dependencyListToArray(program_deps);
        if (engine_deps_array.length > 0 || program_deps_array.length > 0) {
            console.printInfo("Dependencies:");
        }
        int i3 = 0;
        while (i3 < engine_deps_array.length) {
            console.printInfo("  (Engine Dependency)  " + engine_deps_array[i3].getFilePath());
            ++i3;
        }
        i3 = 0;
        while (i3 < program_deps_array.length) {
            console.printInfo("  (Program Dependency)  " + program_deps_array[i3].getFilePath());
            ++i3;
        }
        if (engine_deps_array.length > 0 || program_deps_array.length > 0) {
            console.printInfo("");
        }
        String coordinator_hostname = null;
        DaemonInterface daemon = null;
        try {
            console.printInfo("Connecting to engine daemon...");
            t = System.currentTimeMillis();
            if (!useMiniEngine) {
                URL plugin_dir = Platform.asLocalURL((URL)Platform.find((Bundle)B2jPlugin.getDefault().getBundle(), (IPath)new Path("/")));
                File plugin_file = new File(plugin_dir.getFile());
                File jar_file = new File(String.valueOf(plugin_dir.getFile()) + "/b2j.jar");
                console.printInfo("Starting main engine daemon in " + plugin_file);
                EngineFactory.createMainEngineDaemon(plugin_file, jar_file, 11000);
                SessionAddress daemon_address = bpel_program.getCoordinatorDaemon();
                coordinator_hostname = daemon_address.getListenerHost();
                String protocol = daemon_address.getRequiresEncryption() ? "(HTTPS)" : "(HTTP)";
                String password = daemon_address.getRequiresPassword() ? "(requires password)" : "(no password)";
                console.printInfo("Connecting to main engine daemon on " + coordinator_hostname + " " + protocol + " " + password);
                daemon = EngineFactory.connectToMainEngineDaemon(daemon_address);
            } else {
                console.printInfo("Connecting to in-jvm mini engine daemon");
                daemon = EngineFactory.connectToMiniEngineDaemon();
            }
            t = System.currentTimeMillis() - t;
            console.printInfo("Connected to engine daemon (" + (t /= 1000L) + "sec)");
            console.printInfo("");
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to connect to engine daemon", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to connect to engine daemon", false);
            return;
        }
        this.controller = null;
        try {
            t = System.currentTimeMillis();
            console.printInfo("Creating engine instance...");
            this.controller = daemon.newEngine(bpel_program.getName(), console_tracel, engine_deps_array, bpel_program.getCoordinatorHost());
            daemon.close();
            t = System.currentTimeMillis() - t;
            console.printInfo("Created engine instance (" + (t /= 1000L) + "sec)");
            console.printInfo("");
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to create new engine instance", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to create new engine instance", false);
            return;
        }
        try {
            t = System.currentTimeMillis();
            console.printInfo("Setting engine program...");
            if (!useMiniEngine) {
                console.printInfo("");
                console.printInfo("Distribution:");
                console.printInfo("  (Coordinator host)   " + coordinator_hostname);
                int i4 = 0;
                while (i4 < prog.getAddressCount()) {
                    console.printInfo("  (Worker host)        " + ((SessionAddress)prog.getAddresses().get(i4)).getListenerHost());
                    ++i4;
                }
                console.printInfo("");
            }
            this.controller.setProgram(prog);
            t = System.currentTimeMillis() - t;
            console.printInfo("Set engine program (" + (t /= 1000L) + "sec)");
            console.printInfo("");
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set engine program in engine instance", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to set engine program in engine instance", false);
            return;
        }
        try {
            if (!exitOnDisconnect) {
                this.controller.setHeadless(true);
                console.printInfo("Headless mode, engine will continue to run after workbench disconnects");
                console.printInfo("");
            }
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set headless in engine instance", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to set headless in engine instance", false);
            return;
        }
        try {
            if (debug) {
                console.printInfo("Debug mode, turning on all engine logging");
                console.printInfo("");
                this.controller.setLogLevel(true, true, false);
            } else {
                console.printInfo("Turning on only warning and error logging");
                console.printInfo("");
                this.controller.setLogLevel(true, true, false);
            }
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to set log level in engine instance", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to set log level in engine instance", false);
            return;
        }
        if (debug && launch != null) {
            this.debugTarget = new ControllerDebugTarget(launch, this.controller, bpel_program.getName());
        }
        tott = System.currentTimeMillis() - tott;
        console.printInfo("Total launch time " + (tott /= 1000L) + "sec");
        console.printInfo("");
        try {
            console.printInfo("Launching engine program");
            console.printInfo("");
            this.root_runner_ids = this.controller.launchRunner(1, "engine_main", 0, new String[0]);
        }
        catch (Exception e) {
            this.printFatalProblem(console, "Failed to start engine program", e);
            B2jPlugin.DBG.logVisibleError(e, "Failed to start engine program", false);
            return;
        }
        this.running = true;
    }

    private JARDependency[] dependencyListToArray(ArrayList list) {
        JARDependency[] array = new JARDependency[list.size()];
        list.toArray(array);
        return array;
    }

    private void printFatalProblem(BPELEngineListener console, String description, Exception e) {
        console.printDebug("\n\nERROR: " + description);
        console.printInfo("\nProblem Description:");
        if (e.getMessage() != null) {
            console.printDebug(e.getMessage());
        } else {
            console.printDebug("");
        }
        console.printInfo("\nProblem Details:");
        console.printDebug(WorkbenchBPELEngine.getStacktrace(e));
    }

    private static String getStacktrace(Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream print = new PrintStream(bout);
        t.printStackTrace(print);
        return new String(bout.toByteArray()).replace('\t', ' ');
    }

    private ArrayList fetchAllProgramDependencies(BPELEngineListener console) throws IOException {
        DependencyInfo[] infos = B2jPlatform.getPortDependencyInfo();
        return this.fetchAllDependencies(console, infos);
    }

    private ArrayList fetchAllEngineDependencies(BPELEngineListener console) throws IOException {
        DependencyInfo[] infos = B2jPlatform.getEngineDependencyInfo();
        return this.fetchAllDependencies(console, infos);
    }

    private ArrayList fetchAllDependencies(BPELEngineListener console, DependencyInfo[] infos) throws IOException {
        ArrayList<JARDependency> jardeps = new ArrayList<JARDependency>();
        int i = 0;
        while (i < infos.length) {
            Properties[] props = infos[i].getResources();
            int k = 0;
            while (k < props.length) {
                String path = props[k].getProperty("JAR");
                path = infos[i].getRelativePath(path);
                InputStream in = new FileInputStream(path);
                in = new BufferedInputStream(in);
                byte[] dat = StreamUtils.readAll(in);
                in.close();
                if (path != null) {
                    JARDependency dep = new JARDependency(dat, path);
                    jardeps.add(dep);
                }
                ++k;
            }
            ++i;
        }
        return jardeps;
    }

    private class IgnoredTraceListener
    implements BPELEngineListener {
        private IgnoredTraceListener() {
        }

        public void printInfo(String s) {
        }

        public void printDebug(String s) {
        }

        public void printEngineInfo(String s) {
        }

        public void printEngineDebug(String s) {
        }
    }
}

