/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.xml.internal.XMLParserListener;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Comment;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Text;

public class NodeTreeBuilder
implements XMLParserListener {
    private Element lastElement = null;
    private Document document = null;
    private Node currentnode = null;
    boolean lowercase;
    String fileref;

    public NodeTreeBuilder() {
    }

    public NodeTreeBuilder(String fileref) {
        this.fileref = fileref;
    }

    public Document getRootNode() {
        return this.document;
    }

    public void startElement(String tag, HashMap h, int lineno) throws Exception {
        boolean doEnd = false;
        if (tag.endsWith("/")) {
            doEnd = true;
            tag = tag.substring(0, tag.length() - 1);
        }
        Element tmp = new Element(this.currentnode, tag);
        tmp.setFileRef(this.fileref);
        tmp.setStartLine(lineno);
        if (h != null) {
            tmp.attributes.putAll(h);
        }
        this.currentnode.appendChild(tmp);
        this.currentnode = tmp;
        if (doEnd) {
            this.endElement(tag, lineno);
        }
        this.lastElement = tmp;
    }

    public void endElement(String tag, int lineno) throws Exception {
        this.currentnode.setEndLine(lineno);
        if (this.currentnode.parent != null) {
            this.currentnode = this.currentnode.parent;
        }
    }

    public void startDocument() throws Exception {
        this.document = new Document();
        this.currentnode = this.document;
    }

    public void endDocument() throws Exception {
    }

    public void text(String str, int linefrom, int lineto) throws Exception {
        Text tmp = new Text(this.currentnode, str);
        tmp.setFileRef(this.fileref);
        tmp.setStartLine(linefrom);
        tmp.setEndLine(lineto);
        this.currentnode.appendChild(tmp);
    }

    public void comment(String str, int linefrom, int lineto) throws Exception {
        if (str.startsWith("LINENO ") && this.lastElement != null) {
            try {
                int fileindex = str.indexOf("file ") + 5;
                int numindex = str.indexOf("line ") + 5;
                String file = str.substring(fileindex, numindex - 5).trim();
                int line = Integer.parseInt(str.substring(numindex, str.indexOf(32, numindex)).trim());
                this.lastElement.setFileRef(file);
                this.lastElement.setStartLine(line);
            }
            catch (Exception exception) {
                System.err.println("Invalid line number comment: " + str);
            }
        }
        Comment tmp = new Comment(this.currentnode, str);
        tmp.setFileRef(this.fileref);
        tmp.setStartLine(linefrom);
        tmp.setEndLine(lineto);
        this.currentnode.appendChild(tmp);
    }
}

