/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.soas.internal.deploy.ui.wizards.ISummaryDataSource;
import org.eclipse.stp.soas.internal.deploy.util.DeployUtilPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewDeploymentProfileCreationPage
extends WizardPage
implements ISummaryDataSource {
    private static final String PROPERTY_DEPLOYMENT_VALUE = "deploymentProject";
    private static final String DEPLOYMENT_PROJECT_NAME = "Deployments";
    private final QualifiedName key = new QualifiedName("org.eclipse.stp", "deploymentProject");
    private String smFileExtension;
    private Text txtName;
    private IProject project;

    public NewDeploymentProfileCreationPage(String pageName) {
        super(pageName);
        this.setTitle("Deployment Profile Name");
    }

    public void createControl(Composite parent) {
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(2, false));
        com.setLayoutData((Object)new GridData(1808));
        new Label(com, 0).setText("Name:");
        this.txtName = new Text(com, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.setControl((Control)com);
    }

    public void init(String fileExtension) {
        this.smFileExtension = fileExtension;
        this.project = this.getDeploymentProject();
        try {
            if (this.project == null) {
                this.project = this.createProject();
                this.project.setPersistentProperty(this.key, PROPERTY_DEPLOYMENT_VALUE);
            }
            if (!this.project.isOpen()) {
                this.project.open((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return this.txtName.getText();
    }

    public String getFullFileName() {
        String fileName = this.getFileName();
        if (this.smFileExtension != null && !fileName.endsWith(String.valueOf('.') + this.smFileExtension)) {
            fileName = String.valueOf(fileName) + '.' + this.smFileExtension;
        }
        return fileName;
    }

    public IFile getOutputFile() {
        return this.project.getFile(this.getFullFileName());
    }

    private IProject getDeploymentProject() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen() && projects[i].getPersistentProperty(this.key) != null) {
                    return projects[i];
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private IProject createProject() throws CoreException {
        String prjName;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject prj = root.getProject(prjName = this.generateProjectName(DEPLOYMENT_PROJECT_NAME));
        if (!prj.exists()) {
            prj.create((IProgressMonitor)new NullProgressMonitor());
            prj.open((IProgressMonitor)new NullProgressMonitor());
        }
        return prj;
    }

    private String generateProjectName(String prjNameBase) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String prjName = prjNameBase;
        int i = 1;
        while (root.getProject(prjName).exists()) {
            prjName = String.valueOf(prjNameBase) + ++i;
        }
        return prjName;
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>(1);
        summaryData.add(new String[]{DeployUtilPlugin.getDefault().getResourceString("WizardNewFileCreationPage.summary.fileName"), this.getOutputFile().getFullPath().toString()});
        return summaryData;
    }
}

