/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPathNode;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPU;

public class XPATHTreePrecomputer {
    public void precompute(XPathNode node) {
        this.transformNonVariable(node);
    }

    private boolean transformNonVariable(XPathNode node) {
        boolean variable = false;
        int i = 0;
        while (i < node.getChildCount()) {
            if (this.transformNonVariable(node.getChild(i))) {
                variable = true;
            }
            ++i;
        }
        if (node.getType() == 12) {
            variable = true;
        }
        if (!variable) {
            this.transformNode(node);
        }
        return variable;
    }

    private void transformNode(XPathNode node) {
        if (node.type == 5 || node.type == 4) {
            if (node.getChildCount() == 2) {
                XPathNode childA = node.getChild(0);
                XPathNode childB = node.getChild(1);
                if (childA.getType() == 2 && childB.getType() == 2) {
                    double dA = XPU.toNumber(childA.getArg(0));
                    double dB = XPU.toNumber(childB.getArg(0));
                    if (node.getArg(0).equals("*")) {
                        dA *= dB;
                    } else if (node.getArg(0).equals("div")) {
                        dA /= dB;
                    } else if (node.getArg(0).equals("mod")) {
                        dA %= dB;
                    } else if (node.getArg(0).equals("-")) {
                        dA -= dB;
                    } else if (node.getArg(0).equals("+")) {
                        dA += dB;
                    } else {
                        System.out.println("UNRECOGNISED OPERATOR");
                    }
                    childA.setArg(0, XPU.toString(new Double(dA)));
                    node.getParent().replaceChild(node, childA);
                }
            }
        } else if (node.type == 6) {
            XPathNode child;
            if (node.getArg(0).equals("-") && node.getChildCount() == 1 && (child = node.getChild(0)).getType() == 2) {
                String number = child.getArg(0);
                double dble = XPU.toNumber(number);
                dble = -dble;
                child.setArg(0, XPU.toString(new Double(dble)));
                node.getParent().replaceChild(node, child);
            }
        } else if (node.type == 7) {
            if (node.getChildCount() == 2) {
                XPathNode childA = node.getChild(0);
                XPathNode childB = node.getChild(1);
                if (childA.getType() == 2 && childB.getType() == 2) {
                    double dA = XPU.toNumber(childA.getArg(0));
                    double dB = XPU.toNumber(childB.getArg(0));
                    boolean ret = false;
                    if (node.getArg(0).equals(">")) {
                        ret = dA > dB;
                    } else if (node.getArg(0).equals("<")) {
                        ret = dA < dB;
                    } else if (node.getArg(0).equals(">=")) {
                        ret = dA >= dB;
                    } else if (node.getArg(0).equals("<=")) {
                        ret = dA <= dB;
                    } else {
                        System.out.println("UNRECOGNISED OPERATOR");
                    }
                    XPathNode newChild = new XPathNode(11);
                    newChild.addArg(String.valueOf(ret));
                    node.getParent().replaceChild(node, newChild);
                }
            }
        } else {
            int cfr_ignored_0 = node.type;
        }
    }
}

