/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XSDUtil;

public class CharStack {
    private static final boolean DEBUG_XML = false;
    char[] cs;
    int cslen;
    int index;
    int[] marks = new int[10];
    int markptr = 0;
    boolean fakingEndTag = false;
    int lastStartTag = -1;
    int lastEndTag = -1;
    boolean forward = true;
    char[] rev;

    public String popUntil(String[] stop, boolean returnString) {
        char[][] ars = new char[stop.length][];
        int i = 0;
        while (i < stop.length) {
            ars[i] = stop[i].toCharArray();
            ++i;
        }
        return this.popUntil(ars, returnString);
    }

    public String popUntil(char[][] stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean matched = false;
        int z = 0;
        do {
            z = 0;
            while (z < stop.length) {
                int k = 0;
                while (k < stop[z].length) {
                    if (n + k >= this.cslen || this.cs[n + k] != stop[z][k]) break;
                    if (k == stop.length - 1) {
                        matched = true;
                    }
                    ++k;
                }
                ++z;
            }
            if (!matched) continue;
            n += stop[z].length;
            break;
        } while (++n != this.cslen);
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (matched) {
                String ret = this.weebleString(this.cs, this.index, n - this.index);
                this.index = n;
                return ret;
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    private static char[] cloneReversed(char[] tmp) {
        char[] ntmp = new char[tmp.length];
        int ni = tmp.length - 1;
        int i = 0;
        while (i < tmp.length) {
            ntmp[ni] = tmp[i];
            --ni;
            ++i;
        }
        return ntmp;
    }

    private static char[] cloneReversed(char[] tmp, int off, int len) {
        char[] ntmp = new char[len];
        int i = 0;
        while (i < len) {
            ntmp[len - 1 - i] = tmp[off + i];
            ++i;
        }
        return ntmp;
    }

    private static char[] reverseInPlace(char[] tmp) {
        int len = tmp.length;
        int lenm1 = tmp.length - 1;
        int i = 0;
        while (i < len) {
            char c = tmp[i];
            tmp[i] = tmp[lenm1 - i];
            tmp[lenm1 - i] = c;
            ++i;
        }
        return tmp;
    }

    public CharStack switchDirection() {
        if (this.forward) {
            this.backward();
        } else {
            this.forward();
        }
        return this;
    }

    private void changeDirection() {
        this.forward = !this.forward;
        char[] tmp = this.rev;
        this.rev = this.cs;
        this.cs = tmp;
        this.index = this.cslen - this.index;
    }

    public CharStack backward() {
        if (this.forward) {
            if (this.rev == null) {
                this.rev = CharStack.cloneReversed(this.cs);
            }
            this.changeDirection();
        }
        return this;
    }

    private String weebleString(char[] cs, int off, int len) {
        if (this.forward) {
            return new String(cs, off, len);
        }
        return new String(CharStack.cloneReversed(cs, off, len));
    }

    public CharStack forward() {
        if (!this.forward) {
            this.changeDirection();
        }
        return this;
    }

    public CharStack(String s) {
        this.cs = s.toCharArray();
        this.cslen = this.cs.length;
        this.index = 0;
    }

    public CharStack(String s, int index) {
        this.cs = s.toCharArray();
        this.cslen = this.cs.length;
        this.index = index;
    }

    public boolean isEmpty() {
        return this.index >= this.cslen;
    }

    public char peek() {
        return this.cs[this.index];
    }

    public char pop() {
        return this.cs[this.index++];
    }

    public void mark() {
        this.marks[this.markptr++] = this.index;
        if (this.markptr == this.marks.length) {
            int[] tmp = new int[this.marks.length * 2];
            System.arraycopy(this.marks, 0, tmp, 0, this.marks.length);
            this.marks = tmp;
        }
    }

    public String getSinceMark() {
        return this.weebleString(this.cs, this.marks[this.markptr - 1], this.index - this.marks[this.markptr - 1]);
    }

    public void resetToMark() {
        --this.markptr;
        if (this.markptr == -1) {
            this.markptr = 0;
        }
        this.index = this.marks[this.markptr];
        this.fakingEndTag = false;
    }

    public void popMark() {
        --this.markptr;
        if (this.markptr == -1) {
            this.markptr = 0;
        }
    }

    public double peekNumber() throws NumberFormatException {
        int tmp = this.index;
        double d = this.popNumber();
        this.index = tmp;
        return d;
    }

    public double popNumber() throws NumberFormatException {
        int n = this.index;
        char c = this.cs[n];
        if (c == '-') {
            c = this.cs[++n];
        }
        while (Character.isDigit(c) || c == '.') {
            if (++n == this.cslen) break;
            c = this.cs[n];
        }
        if (n != this.cslen && (this.cs[n] == 'E' || this.cs[n] == 'e') && ++n != this.cslen) {
            if (this.cs[n] == '-') {
                ++n;
            }
            while (Character.isDigit(this.cs[n])) {
                if (++n == this.cslen) break;
            }
        }
        if (n == this.index) {
            throw new NumberFormatException("no digits found " + this.weebleString(this.cs, this.index, Math.min(this.index + 5, this.cslen) - this.index));
        }
        double d = Double.parseDouble(this.weebleString(this.cs, this.index, n - this.index));
        this.index = n;
        return d;
    }

    public void popWhitespace() {
        if (this.index == this.cslen) {
            return;
        }
        int n = this.index;
        char ch = this.cs[n];
        while (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r') {
            if (++n == this.cslen) break;
            ch = this.cs[n];
        }
        this.index = n;
    }

    public String popText(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        while (this.cs[n] != ' ' && this.cs[n] != '\t' && this.cs[n] != '\r' && this.cs[n] != '\n') {
            if (++n == this.cslen) break;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popUntil(String stop, boolean returnString) {
        return this.popUntil(stop.toCharArray(), returnString);
    }

    public String popUntil(char[] stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean matched = false;
        do {
            int k = 0;
            while (k < stop.length) {
                if (n + k >= this.cslen || this.cs[n + k] != stop[k]) break;
                if (k == stop.length - 1) {
                    matched = true;
                }
                ++k;
            }
            if (!matched) continue;
            n += stop.length;
            break;
        } while (++n != this.cslen);
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (matched) {
                String ret = this.weebleString(this.cs, this.index, n - stop.length - this.index);
                this.index = n;
                return ret;
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popUntil(char stop, boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        while (this.cs[n] != stop) {
            if (++n == this.cslen) break;
        }
        if (n != this.cslen) {
            ++n;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            if (n != this.cslen && this.cs[n] == stop) {
                String ret = this.weebleString(this.cs, this.index, n - this.index);
                this.index = n;
                return ret;
            }
            if (n == this.cslen) {
                ++n;
            }
            String ret = this.weebleString(this.cs, this.index, n - 1 - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlText(boolean returnString) {
        return this.popXmlText(returnString, true);
    }

    public String popXmlText(boolean returnString, boolean skipAllNonTags) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        boolean hasEscaped = false;
        StringBuffer sb = null;
        boolean parsingTag = false;
        boolean flaggy = true;
        while (flaggy) {
            flaggy = false;
            while (this.cs[n] != '<') {
                if (this.cs[n] == '&') {
                    hasEscaped = true;
                }
                if (this.cs[n] == '>' && parsingTag) {
                    this.index = n + 1;
                }
                if (++n == this.cslen) break;
            }
            if (!skipAllNonTags || n + 1 >= this.cslen || this.cs[n] != '<' || this.cs[n + 1] != '?' && this.cs[n + 1] != '!') continue;
            ++n;
            flaggy = true;
            parsingTag = true;
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(this.weebleString(this.cs, this.index, n - this.index - 1));
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            if (sb != null) {
                ret = String.valueOf(sb.toString()) + ret;
            }
            if (hasEscaped) {
                ret = XSDUtil.fromXMLString(ret);
            }
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlIdentifier(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        int n = this.index;
        char ch = this.cs[n];
        while (ch > '/' && ch < ';' || ch > '@' && ch < '[' || ch > '`' && ch < '{' || ch == '_') {
            if (++n == this.cslen) break;
            ch = this.cs[n];
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            this.index = n;
            return ret;
        }
        this.index = n;
        return null;
    }

    public String popXmlQuoted(boolean returnString) {
        if (this.isEmpty()) {
            return "";
        }
        char quote = this.pop();
        boolean hasEscaped = false;
        int n = this.index;
        while (this.cs[n] != quote) {
            if (this.cs[n] == '&') {
                hasEscaped = true;
            }
            if (++n == this.cslen) break;
        }
        if (returnString) {
            if (n == this.index) {
                return "";
            }
            String ret = this.weebleString(this.cs, this.index, n - this.index);
            if (hasEscaped) {
                ret = XSDUtil.fromXMLString(ret);
            }
            this.index = n + 1;
            return ret;
        }
        this.index = n + 1;
        return null;
    }

    public String popXmlElementStart() {
        this.popXmlText(false, true);
        if (this.isEmpty()) {
            return "";
        }
        int startIndex = this.index;
        this.pop();
        if (this.peek() == '/') {
            this.pop();
            this.popWhitespace();
            String id = this.popXmlIdentifier(true);
            return "/" + id;
        }
        this.popWhitespace();
        this.lastStartTag = startIndex;
        String id = this.popXmlIdentifier(true);
        if (this.fakingEndTag) {
            this.index = this.lastEndTag;
            return "/" + id;
        }
        return id;
    }

    public void popXmlAttributes() {
        String attr = this.popXmlAttributeName();
        while (attr.length() > 0) {
            this.popWhitespace();
            this.pop();
            this.popWhitespace();
            this.popXmlQuoted(false);
            attr = this.popXmlAttributeName();
        }
    }

    public HashMap popXmlAttributesAsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String attr = this.popXmlAttributeName();
        while (attr.length() > 0) {
            this.popWhitespace();
            this.pop();
            this.popWhitespace();
            String val = this.popXmlQuoted(true);
            map.put(attr, val);
            attr = this.popXmlAttributeName();
        }
        return map;
    }

    public String popXmlAttributeName() {
        this.popWhitespace();
        return this.popXmlIdentifier(true);
    }

    public String popXmlAttributeValue() {
        this.popWhitespace();
        this.pop();
        this.popWhitespace();
        return this.popXmlQuoted(true);
    }

    public void popXmlElementEnd() {
        this.popWhitespace();
        if (this.fakingEndTag) {
            this.fakingEndTag = false;
            this.index = this.lastEndTag;
        }
        if (this.peek() == '/') {
            this.pop();
            this.fakingEndTag = true;
            this.lastEndTag = this.index;
            this.pop();
            this.index = this.lastStartTag;
        } else {
            this.fakingEndTag = false;
            this.pop();
        }
    }

    public String popXmlSubTree(boolean returnString) {
        int begin = this.index;
        boolean done = false;
        while (!done) {
            this.popXmlText(false);
            int tmp = this.index;
            String start = this.popXmlElementStart();
            if (start.length() > 0) {
                if (start.charAt(0) == '/') {
                    this.index = tmp;
                    done = true;
                    continue;
                }
                this.popXmlAttributes();
                this.popXmlElementEnd();
                this.popXmlSubTree(false);
                this.popXmlElementStart();
                this.popXmlElementEnd();
                continue;
            }
            done = true;
        }
        this.popXmlText(false);
        if (returnString) {
            return this.weebleString(this.cs, begin, this.index - begin);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.weebleString(this.cs, this.index, Math.min(this.index + 20, this.cslen) - this.index)) + "...";
    }

    public void debugStack(String s) {
        System.out.println("STACK PARSING=" + s);
        System.out.println("STACK SIZE=" + this.cslen);
        System.out.println("STACK PTR=" + this.index);
        System.out.println("STACK FAKE END=" + this.fakingEndTag);
        System.out.println("STACK CONTENTS=" + this.weebleString(this.cs, this.index, Math.min(this.index + 60, this.cslen) - this.index) + "...");
    }

    public String getStack() {
        return this.weebleString(this.cs, 0, this.cslen);
    }

    private static void testXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(" <\tUSAddress  \t country= \"US\">");
        sb.append(" TEXT");
        sb.append(" </USAddress> TEXT &lt;&gt;&quot;&apos;&amp;");
        CharStack cs = new CharStack(sb.toString());
        String tmp = cs.popXmlElementStart();
        if (!tmp.equals("USAddress")) {
            System.err.println("Popped element incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlAttributeName()).equals("country")) {
            System.err.println("Popped attribute name incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlAttributeValue()).equals("US")) {
            System.err.println("Popped attribute value incorrectly - [" + tmp + "]");
        }
        cs.popXmlElementEnd();
        tmp = cs.popXmlText(true);
        if (!tmp.equals(" TEXT ")) {
            System.err.println("Popped text incorrectly - [" + tmp + "]");
        }
        if (!(tmp = cs.popXmlElementStart()).equals("/USAddress")) {
            System.err.println("Popped element incorrectly - [" + tmp + "]");
        }
        cs.popXmlElementEnd();
        tmp = cs.popXmlElementStart();
        if (tmp.length() > 0) {
            System.err.println("popped element name from text - [" + tmp + "]");
        }
        if (!cs.isEmpty()) {
            System.err.println("Finished reading all XML but not empty??");
        }
        sb = new StringBuffer();
        sb.append("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 </flinder>");
        cs = new CharStack(sb.toString());
        String ret = cs.popXmlSubTree(true);
        if (!ret.equals("OTHER TEXT1 <MINI_NODE /> OTHER TEXT2 <N1><N2><MINI_NODE2 /></N2></N1> OTHER TEXT3 ")) {
            System.out.println("Popped subtree incorrectly:[" + ret + "]");
        } else {
            System.out.println("Popped subtree correctly:" + ret);
        }
        String soapTest = "   <result xsi:type=\"ns2:string\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ns2=\"http://www.w3.org/2001/XMLSchema\">ni hao</result>";
        cs = new CharStack(soapTest);
        cs.popXmlText(false);
        tmp = cs.popXmlElementStart();
        if (!tmp.equals("result")) {
            System.out.println("popped SOAP element incorrectly - [" + tmp + "]");
        } else {
            System.out.println("popped SOAP element OK - [" + tmp + "]");
        }
        String commentTest = "  <TAG> some <!-- COMMENT --><!--comment 2--> te<!--comment3-->xt </TAG>";
        cs = new CharStack(commentTest);
        cs.popXmlElementStart();
        cs.popXmlAttributes();
        cs.popXmlElementEnd();
        String txt = cs.popXmlText(true);
        if (txt.equals(" some  text ")) {
            System.out.println("popped xml text interspersed with comments OK [" + txt + "]");
        } else {
            System.out.println("popped xml text interspersed with comments incorrectly [" + txt + "]");
        }
    }

    public static void main(String[] args) {
        CharStack.testXML();
        CharStack cs = new CharStack(args[0]);
        cs.popXmlElementStart();
        cs.popXmlAttributes();
        cs.popXmlElementEnd();
        while (!cs.isEmpty()) {
            cs.popXmlElementStart();
            cs.popXmlAttributes();
            cs.popXmlElementEnd();
        }
    }
}

