/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.jcompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.stp.b2j.core.jengine.internal.utils.JARFinder;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.JavaCompiler;

public class IndependantExternalJavaCompiler
implements JavaCompiler {
    private CompilerUnit mainsrc;
    private CompilerUnit[] allsrc = new CompilerUnit[1];
    private byte[] theclass;
    private byte[][] classes;
    private String[] classespkgs;
    boolean finished = false;

    public void setMainSourceFile(CompilerUnit src) {
        this.allsrc[0] = this.mainsrc = src;
    }

    public void addExtraSources(CompilerUnit[] sources) {
        CompilerUnit[] tmp = new CompilerUnit[this.allsrc.length + sources.length];
        System.arraycopy(this.allsrc, 0, tmp, 0, this.allsrc.length);
        System.arraycopy(sources, 0, tmp, this.allsrc.length, sources.length);
        this.allsrc = tmp;
    }

    public void compile() throws Exception {
        try {
            File destDirectory = File.createTempFile("IndependantExternalJavaCompilation", "");
            destDirectory.delete();
            if (!destDirectory.mkdirs()) {
                throw new Exception("Failed to make temporary directory " + destDirectory);
            }
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("javac");
            commands.add("-classpath");
            commands.add(this.getClassPath());
            commands.add("-d");
            commands.add(destDirectory.toString());
            File[] sourceFiles = this.writeSourceFiles(destDirectory.getCanonicalPath());
            int i = 0;
            while (i < sourceFiles.length) {
                commands.add(sourceFiles[i].getCanonicalPath());
                ++i;
            }
            String[] exec = new String[commands.size()];
            commands.toArray(exec);
            Process p = this.run(exec, destDirectory);
            this.finished = false;
            StreamPrinter oprinter = new StreamPrinter(p.getInputStream());
            StreamPrinter eprinter = new StreamPrinter(p.getErrorStream());
            p.waitFor();
            this.finished = true;
            oprinter.interrupt();
            eprinter.interrupt();
            if (p.exitValue() != 0) {
                System.out.println("Compilation Failed:");
                int i2 = 0;
                while (i2 < exec.length) {
                    System.out.println("CMD " + i2 + ": " + exec[i2]);
                    ++i2;
                }
                System.out.println("Classpath: " + this.getClassPath());
                System.out.println(eprinter.getPrinted());
                throw new Exception("Compilation failed");
            }
            ArrayList cpaths = new ArrayList();
            JARFinder.searchDir(cpaths, destDirectory, ".class", 1000);
            String cfname = this.getClassFileName(this.allsrc[0].getClassName());
            this.theclass = null;
            String destpath = destDirectory.getAbsolutePath().replace('\\', '/');
            if (!destpath.endsWith("/")) {
                destpath = String.valueOf(destpath) + "/";
            }
            int destpathlen = destpath.length();
            this.classes = new byte[cpaths.size() - 1][];
            this.classespkgs = new String[cpaths.size() - 1];
            int i3 = 0;
            while (i3 < cpaths.size()) {
                String path = (String)cpaths.get(i3);
                String pkg = path.replace('\\', '/');
                pkg = pkg.substring(destpathlen);
                FileInputStream fin = new FileInputStream(path);
                if (path.endsWith(cfname)) {
                    this.theclass = StreamUtils.readAll(fin);
                } else if (this.theclass == null) {
                    this.classes[i3] = StreamUtils.readAll(fin);
                    this.classespkgs[i3] = pkg;
                } else {
                    this.classes[i3 - 1] = StreamUtils.readAll(fin);
                    this.classespkgs[i3 - 1] = pkg;
                }
                fin.close();
                ++i3;
            }
            this.deleteDirs(destDirectory);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    private Process run(String[] command, File destDirectory) throws IOException {
        Process p = Runtime.getRuntime().exec(command, null, destDirectory);
        return p;
    }

    private String getClassPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(new File(B2jPlatform.getPlatformFolder() + "/b2j.jar").getAbsolutePath());
        DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
        int i = 0;
        while (i < infos.length) {
            Properties[] props = infos[i].getResources();
            int k = 0;
            while (k < props.length) {
                sb.append(System.getProperty("path.separator"));
                sb.append(infos[i].getRelativePath(props[k].getProperty("JAR")));
                ++k;
            }
            ++i;
        }
        String s = sb.toString();
        s = File.separatorChar == '/' ? s.replace('\\', '/') : s.replace('/', '\\');
        return s;
    }

    private File[] writeSourceFiles(String dir) throws IOException {
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        int CONFIGS_LEN = 0;
        String[] srcnames = new String[CONFIGS_LEN + this.allsrc.length];
        FileOutputStream allout = null;
        try {
            allout = new FileOutputStream("C:\\temp\\ALLSRC.java");
            new File("C:\\temp\\ALLSRC").mkdirs();
        }
        catch (Exception e) {
            System.out.println("Could not open generated source debugging file: " + e);
            allout = null;
        }
        int i = 0;
        while (i < this.allsrc.length) {
            String pkgname = this.allsrc[i].getPackageName();
            String cname = this.allsrc[i].getClassName();
            String srcname = this.getSrcName(pkgname, cname);
            File tmpfile = new File(String.valueOf(dir) + srcname);
            tmpfile.mkdirs();
            tmpfile.delete();
            srcnames[CONFIGS_LEN + i] = String.valueOf(dir) + srcname;
            FileOutputStream fout = new FileOutputStream(String.valueOf(dir) + srcname);
            fout.write(this.allsrc[i].toString().getBytes());
            fout.flush();
            try {
                if (allout != null) {
                    allout.write(this.allsrc[i].toString().getBytes());
                }
            }
            catch (Exception e) {
                System.out.println("Failed to write to generated source debugging file: " + e);
                allout = null;
            }
            try {
                String fname = pkgname;
                fname = fname.substring(fname.indexOf(46) + 1);
                fname = fname.replace('.', '_');
                fname = String.valueOf(fname) + cname;
                FileOutputStream tmpfout = new FileOutputStream("C:\\temp\\ALLSRC\\" + fname + ".java");
                tmpfout.write(this.allsrc[i].toString().getBytes());
                tmpfout.close();
            }
            catch (Exception exception) {}
            fout.close();
            ++i;
        }
        if (allout != null) {
            allout.flush();
            allout.close();
        }
        File[] tmp = new File[srcnames.length];
        int i2 = 0;
        while (i2 < tmp.length) {
            tmp[i2] = new File(srcnames[i2]);
            ++i2;
        }
        return tmp;
    }

    public byte[] getMainSourceClass() {
        return this.theclass;
    }

    public byte[][] getExtraSourceClasses() {
        return this.classes;
    }

    public String[] getExtraSourceClassesPackages() {
        return this.classespkgs;
    }

    private String getSrcName(String pkgname, String cname) {
        pkgname = pkgname.replace('.', '/');
        return String.valueOf(pkgname) + '/' + cname + ".java";
    }

    private void deleteDirs(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDirs(files[i]);
                ++i;
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    private String getClassFileName(String cname) {
        return String.valueOf(cname.substring(cname.lastIndexOf(46) + 1)) + ".class";
    }

    private class StreamPrinter
    extends Thread {
        StringBuffer sb = new StringBuffer();
        InputStream in;

        public StreamPrinter(InputStream in) {
            this.in = in;
            this.start();
        }

        public String getPrinted() {
            return this.sb.toString();
        }

        public void run() {
            try {
                while (!IndependantExternalJavaCompiler.this.finished) {
                    this.sb.append((char)this.in.read());
                }
            }
            catch (Exception exception) {}
        }
    }
}

