/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.jcompiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.utils.JARFinder;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.Debugger;
import org.eclipse.stp.b2j.core.misc.internal.MultiOutputStream;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.JavaCompiler;
import org.osgi.framework.Bundle;

public class WorkbenchJDTJavaCompiler
implements JavaCompiler {
    Debugger DBG = B2jPlugin.DBG;
    CompilerUnit mainsrc;
    CompilerUnit[] allsrc = new CompilerUnit[1];
    byte[] theclass;
    byte[][] classes;
    String[] classespkgs;

    public void setMainSourceFile(CompilerUnit src) {
        this.allsrc[0] = this.mainsrc = src;
    }

    public void addExtraSources(CompilerUnit[] sources) {
        CompilerUnit[] tmp = new CompilerUnit[this.allsrc.length + sources.length];
        System.arraycopy(this.allsrc, 0, tmp, 0, this.allsrc.length);
        System.arraycopy(sources, 0, tmp, this.allsrc.length, sources.length);
        this.allsrc = tmp;
    }

    public void compile() throws Exception {
        File file = File.createTempFile("WorkbenchJDTJavaCompilation", "");
        file.delete();
        if (!file.mkdirs()) {
            Exception e = new Exception("problem creating temporary compilation directory:" + file);
            this.DBG.error("Problem compiling:", e);
            throw e;
        }
        String dir = file.getCanonicalPath();
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        this.DBG.info("Writing java source code to tmp directory " + dir);
        int CONFIGS_LEN = 6;
        String[] srcnames = new String[CONFIGS_LEN + this.allsrc.length];
        FileOutputStream allout = null;
        try {
            allout = new FileOutputStream("C:\\temp\\ALLSRC.java");
            new File("C:\\temp\\ALLSRC").mkdirs();
        }
        catch (Exception e) {
            this.DBG.warning("Could not open generated source debugging file", e);
            allout = null;
        }
        int i = 0;
        while (i < this.allsrc.length) {
            String pkgname = this.allsrc[i].getPackageName();
            String cname = this.allsrc[i].getClassName();
            String srcname = this.getSrcName(pkgname, cname);
            File tmpfile = new File(String.valueOf(dir) + srcname);
            tmpfile.mkdirs();
            tmpfile.delete();
            srcnames[CONFIGS_LEN + i] = String.valueOf(dir) + srcname;
            FileOutputStream fout = new FileOutputStream(String.valueOf(dir) + srcname);
            fout.write(this.allsrc[i].toString().getBytes());
            fout.flush();
            try {
                if (allout != null) {
                    allout.write(this.allsrc[i].toString().getBytes());
                }
            }
            catch (Exception e) {
                this.DBG.warning("Failed to write to generated source debugging file", e);
                allout = null;
            }
            try {
                String fname = pkgname;
                fname = fname.substring(fname.indexOf(46) + 1);
                fname = fname.replace('.', '_');
                fname = String.valueOf(fname) + cname;
                FileOutputStream tmpfout = new FileOutputStream("C:\\temp\\ALLSRC\\" + fname + ".java");
                tmpfout.write(this.allsrc[i].toString().getBytes());
                tmpfout.close();
            }
            catch (Exception exception) {}
            fout.close();
            this.DBG.info("Wrote java source for " + srcname);
            ++i;
        }
        if (allout != null) {
            allout.flush();
            allout.close();
        }
        URL plugin_dir = Platform.asLocalURL((URL)Platform.find((Bundle)B2jPlugin.getDefault().getBundle(), (IPath)new Path("/")));
        new File(plugin_dir.getFile());
        File jar_file = new File(String.valueOf(plugin_dir.getFile()) + "/b2j.jar");
        ArrayList<String> jars = new ArrayList<String>();
        DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
        int i2 = 0;
        while (i2 < infos.length) {
            Properties[] props = infos[i2].getResources();
            int k = 0;
            while (k < props.length) {
                jars.add(infos[i2].getRelativePath(props[k].getProperty("JAR")));
                ++k;
            }
            ++i2;
        }
        srcnames[0] = "-classpath";
        StringBuffer cpath = new StringBuffer();
        cpath.append(jar_file.getAbsolutePath());
        int i3 = 0;
        while (i3 < jars.size()) {
            cpath.append(System.getProperty("path.separator"));
            cpath.append((String)jars.get(i3));
            ++i3;
        }
        srcnames[1] = cpath.toString();
        srcnames[2] = "-d";
        srcnames[3] = dir;
        srcnames[4] = "-noExit";
        srcnames[5] = "-nowarn";
        this.DBG.info("CLASSPATH = " + srcnames[1]);
        System.gc();
        ByteArrayOutputStream compiler_out = new ByteArrayOutputStream();
        PrintWriter mout = new PrintWriter(new PrintStream(new MultiOutputStream(new OutputStream[]{System.err, compiler_out})));
        Main compiler = new Main(mout, mout, false);
        boolean compiledOK = compiler.compile(srcnames);
        if (!compiledOK) {
            this.deleteDirs(dir);
            throw new Exception("Translated BPEL compilation failed\n\nCompiler Output:\n\n" + new String(compiler_out.toByteArray()) + "\n\n");
        }
        ArrayList cpaths = new ArrayList();
        JARFinder.searchDir(cpaths, new File(dir), ".class", 1000);
        String cfname = this.getClassFileName(this.allsrc[0].getClassName());
        this.theclass = null;
        String destpath = new File(dir).getAbsolutePath().replace('\\', '/');
        if (!destpath.endsWith("/")) {
            destpath = String.valueOf(destpath) + "/";
        }
        int destpathlen = destpath.length();
        this.classes = new byte[cpaths.size() - 1][];
        this.classespkgs = new String[cpaths.size() - 1];
        int i4 = 0;
        while (i4 < cpaths.size()) {
            String path = (String)cpaths.get(i4);
            String pkg = path.replace('\\', '/');
            pkg = pkg.substring(destpathlen);
            FileInputStream fin = new FileInputStream(path);
            System.out.println(String.valueOf(cfname) + " ? " + path);
            if (path.endsWith(cfname)) {
                this.theclass = StreamUtils.readAll(fin);
            } else if (this.theclass == null) {
                this.classes[i4] = StreamUtils.readAll(fin);
                this.classespkgs[i4] = pkg;
            } else {
                this.classes[i4 - 1] = StreamUtils.readAll(fin);
                this.classespkgs[i4 - 1] = pkg;
            }
            fin.close();
            ++i4;
        }
        this.deleteDirs(dir);
    }

    public byte[] getMainSourceClass() {
        return this.theclass;
    }

    public byte[][] getExtraSourceClasses() {
        return this.classes;
    }

    public String[] getExtraSourceClassesPackages() {
        return this.classespkgs;
    }

    private void deleteDirs(String dir) {
        File f = new File(dir);
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDirs(files[i].getAbsolutePath());
                ++i;
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    private String getClassFileName(String cname) {
        return String.valueOf(cname.substring(cname.lastIndexOf(46) + 1)) + ".class";
    }

    private String getSrcName(String pkgname, String cname) {
        pkgname = pkgname.replace('.', '/');
        return String.valueOf(pkgname) + '/' + cname + ".java";
    }
}

