/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.delete.operations;

import java.util.List;
import java.util.Set;
import javax.wsdl.Import;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.delete.operations.DeleteServiceOperation;
import org.eclipse.stp.core.delete.operations.IDeleteServiceDataModelProperties;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.operations.AbstractScribblerDataModelProvider;
import org.eclipse.stp.core.internal.Messages;
import org.eclipse.stp.core.internal.STPCorePlugin;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.Service;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

public class DeleteServiceDataModelProvider
extends AbstractScribblerDataModelProvider
implements IDeleteServiceDataModelProperties {
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IDeleteInterfaceDataModelProperties.COMPONENT_TYPE");
        propertyNames.add("IDeleteInterfaceDataModelProperties.SERVICE_NAMES");
        return propertyNames;
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IDeleteInterfaceDataModelProperties.SERVICE_NAMES")) {
            return this.validateServiceNames();
        }
        if (propertyName.equals("IDeleteInterfaceDataModelProperties.COMPONENT_TYPE")) {
            return this.validatePart();
        }
        return super.validate(propertyName);
    }

    private IStatus validatePart() {
        Object object = this.getProperty("IDeleteInterfaceDataModelProperties.COMPONENT_TYPE");
        if (!(object instanceof ComponentType || object instanceof Import || object instanceof EntryPoint)) {
            return STPCorePlugin.createErrorStatus(Messages.invalidObjectPassed_errorText, null);
        }
        return OK_STATUS;
    }

    public IDataModelOperation getDefaultOperation() {
        return new DeleteServiceOperation(this.model);
    }

    private IStatus validateServiceNames() {
        ComponentType componentType = (ComponentType)this.model.getProperty("IDeleteInterfaceDataModelProperties.COMPONENT_TYPE");
        List services = componentType.getServices();
        String[] serviceNames = (String[])this.model.getProperty("IDeleteInterfaceDataModelProperties.SERVICE_NAMES");
        Assert.isTrue((services.size() >= serviceNames.length ? 1 : 0) != 0);
        int i = 0;
        while (i < serviceNames.length) {
            Service service = null;
            int serviceIndex = 0;
            while (serviceIndex < services.size()) {
                service = (Service)services.get(serviceIndex);
                if (service.getName().equals(serviceNames[i])) break;
                service = null;
                ++serviceIndex;
            }
            if (service == null) {
                return STPCorePlugin.createErrorStatus(NLS.bind((String)Messages.serviceName_not_inComponentType, (Object)serviceNames[i]), null);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }
}

