/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.introspection.ComponentTypeIntrospectorRegistry;
import org.eclipse.stp.core.introspection.FeatureAdapter;
import org.eclipse.stp.core.introspection.IComponentTypeIntrospector;
import org.eclipse.stp.core.introspection.IModelIntrospectionManager;
import org.eclipse.stp.core.introspection.IShareableComponentTypeFactory;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.ComponentType;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.stp.core.sca.UnknownImplementation;
import org.eclipse.stp.core.sca.impl.ComponentTypeImpl;

public class ModelIntrospectionManager
implements IModelIntrospectionManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(ComponentType componentType, URI implementation) {
        ComponentType componentType2 = componentType;
        synchronized (componentType2) {
            if (ModelIntrospectionManager.findAdapter(componentType) == null) {
                ((ComponentTypeImpl)componentType).unbind();
                IComponentTypeIntrospector introspector = ComponentTypeIntrospectorRegistry.getInstance().createAndBindIntrospector(componentType, implementation);
                IStatus validComponentTypeStatus = introspector.hasValidComponentType();
                if (!validComponentTypeStatus.isOK()) {
                    componentType.addStatus(validComponentTypeStatus);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(ComponentType componentType) {
        ComponentType componentType2 = componentType;
        synchronized (componentType2) {
            IComponentTypeIntrospector introspector = ModelIntrospectionManager.findAdapter(componentType);
            if (introspector != null) {
                componentType.getEObject().eAdapters().remove((Object)introspector);
                introspector.dispose();
                ((ComponentTypeImpl)componentType).unbind();
                componentType.clearStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentType resolve(Implementation implementation) {
        Assert.isTrue((implementation != null ? 1 : 0) != 0);
        Assert.isTrue((implementation.getEObject() != null ? 1 : 0) != 0);
        Assert.isTrue((implementation.getEObject().eClass().equals(SCAPackage.eINSTANCE.getAbstractImplementation()) || implementation.getEObject().eResource() != null && implementation.getEObject().eResource().getResourceSet() != null ? 1 : 0) != 0);
        Implementation implementation2 = implementation;
        synchronized (implementation2) {
            URI readyShareableURI;
            Resource componentTypeResource;
            EStructuralFeature feature;
            IFile shareableFile;
            ResourceSet resourceSet;
            EObject eObject;
            block10: {
                ResourceSet resourceSet2;
                eObject = implementation.getEObject();
                EClass eClass = eObject.eClass();
                if (SCAPackage.eINSTANCE.getAbstractImplementation().equals(eClass)) {
                    return ((AbstractImplementation)implementation).getComponentType();
                }
                if (!SCAPackage.eINSTANCE.getUnknownImplementation().equals(eClass)) break block10;
                UnknownImplementation unknown = (UnknownImplementation)implementation;
                if (eObject.eResource() != null && (resourceSet2 = eObject.eResource().getResourceSet()) != null) {
                    Resource componentTypeResource2 = resourceSet2.getResource(URI.createURI((String)unknown.getUri()), true);
                    SCACoreRoot root = (SCACoreRoot)componentTypeResource2.getContents().get(0);
                    return root.getComponentType();
                }
                return null;
            }
            IShareableComponentTypeFactory factory = ComponentTypeIntrospectorRegistry.getInstance().getShareableFactory(implementation);
            if (factory == null) {
                ComponentType componentType = SCAFactory.eINSTANCE.createComponentType();
                IComponentTypeIntrospector introspector = ComponentTypeIntrospectorRegistry.getInstance().createIntrospector(implementation);
                if (introspector != null) {
                    componentType.getEObject().eAdapters().add((Object)introspector);
                    IStatus validComponentTypeStatus = introspector.hasValidComponentType();
                    if (!validComponentTypeStatus.isOK()) {
                        componentType.addStatus(validComponentTypeStatus);
                    }
                }
                return componentType;
            }
            if (eObject.eResource() != null && (resourceSet = eObject.eResource().getResourceSet()) != null && (shareableFile = factory.findShareableFile(feature = ModelIntrospectionManager.getStructuralFeature(implementation), implementation)) != null && (componentTypeResource = resourceSet.getResource(readyShareableURI = URI.createURI((String)("comptype:" + shareableFile.getFullPath().toString())), true)).getContents().size() > 0) {
                SCACoreRoot root = (SCACoreRoot)componentTypeResource.getContents().get(0);
                return root.getComponentType();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentType resolve(Implementation implementation, IProject context) {
        Assert.isTrue((implementation != null ? 1 : 0) != 0);
        Assert.isTrue((implementation.getEObject() != null ? 1 : 0) != 0);
        Assert.isTrue((implementation.getEObject().eClass().equals(SCAPackage.eINSTANCE.getAbstractImplementation()) || implementation.getEObject().eResource() != null && implementation.getEObject().eResource().getResourceSet() != null ? 1 : 0) != 0);
        Implementation implementation2 = implementation;
        synchronized (implementation2) {
            URI readyShareableURI;
            Resource componentTypeResource;
            EStructuralFeature feature;
            IFile shareableFile;
            ResourceSet resourceSet;
            EObject eObject;
            block10: {
                ResourceSet resourceSet2;
                eObject = implementation.getEObject();
                EClass eClass = eObject.eClass();
                if (SCAPackage.eINSTANCE.getAbstractImplementation().equals(eClass)) {
                    return ((AbstractImplementation)implementation).getComponentType();
                }
                if (!SCAPackage.eINSTANCE.getUnknownImplementation().equals(eClass)) break block10;
                UnknownImplementation unknown = (UnknownImplementation)implementation;
                if (eObject.eResource() != null && (resourceSet2 = eObject.eResource().getResourceSet()) != null) {
                    Resource componentTypeResource2 = resourceSet2.getResource(URI.createURI((String)unknown.getUri()), true);
                    SCACoreRoot root = (SCACoreRoot)componentTypeResource2.getContents().get(0);
                    return root.getComponentType();
                }
                return null;
            }
            IShareableComponentTypeFactory factory = ComponentTypeIntrospectorRegistry.getInstance().getShareableFactory(implementation);
            if (factory == null) {
                ComponentType componentType = SCAFactory.eINSTANCE.createComponentType();
                IComponentTypeIntrospector introspector = ComponentTypeIntrospectorRegistry.getInstance().createIntrospector(implementation);
                if (introspector != null) {
                    componentType.getEObject().eAdapters().add((Object)introspector);
                    IStatus validComponentTypeStatus = introspector.hasValidComponentType();
                    if (!validComponentTypeStatus.isOK()) {
                        componentType.addStatus(validComponentTypeStatus);
                    }
                }
                return componentType;
            }
            if (eObject.eResource() != null && (resourceSet = eObject.eResource().getResourceSet()) != null && (shareableFile = factory.findShareableFile(feature = ModelIntrospectionManager.getStructuralFeature(implementation), implementation)) != null && (componentTypeResource = resourceSet.getResource(readyShareableURI = URI.createURI((String)("comptype:" + shareableFile.getFullPath().toString())), true)).getContents().size() > 0) {
                SCACoreRoot root = (SCACoreRoot)componentTypeResource.getContents().get(0);
                return root.getComponentType();
            }
        }
        return null;
    }

    public static EStructuralFeature getStructuralFeature(SCAObject anSCAObject) {
        FeatureAdapter adapter = null;
        if (anSCAObject == null) {
            return null;
        }
        Assert.isTrue((anSCAObject.getEObject().eContainer() != null && anSCAObject.getEObject().eContainer().eContainingFeature() != null || (adapter = FeatureAdapter.findAdapter(anSCAObject)) != null ? 1 : 0) != 0);
        if (adapter != null) {
            return adapter.getFeature();
        }
        EStructuralFeature feature = anSCAObject.getEObject().eContainingFeature();
        if (((EStructuralFeature.Internal)feature).isFeatureMap()) {
            FeatureMap map = (FeatureMap)anSCAObject.getEObject().eContainer().eGet(feature);
            return map.getEStructuralFeature(0);
        }
        return feature;
    }

    public static String getSubstitutionGroupName(SCAObject anSCAObject) {
        return ExtendedMetaData.INSTANCE.getName(ModelIntrospectionManager.getStructuralFeature(anSCAObject));
    }

    private static IComponentTypeIntrospector findAdapter(ComponentType componentType) {
        return (IComponentTypeIntrospector)EcoreUtil.getAdapter((List)componentType.getEObject().eAdapters(), (Object)IComponentTypeIntrospector.ADAPTER_TYPE);
    }
}

