/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.operations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.internal.operations.ComponentTypingOperation;
import org.eclipse.stp.core.internal.operations.IComponentTypingDataModelProperties;
import org.eclipse.stp.core.internal.saf.impl.Messages;
import org.eclipse.stp.core.internal.saf.impl.SAFActivator;
import org.eclipse.stp.core.saf.exception.InvalidOperationException;
import org.eclipse.stp.core.sca.AbstractImplementation;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.Implementation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ComponentTypingDataModelProvider
extends AbstractDataModelProvider
implements IComponentTypingDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        if (this.model == null) {
            this.model = DataModelFactory.createDataModel((IDataModelProvider)this);
        }
        return new ComponentTypingOperation(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IComponentTypingDataModelProperties.SET_TYPE");
        propertyNames.add("IComponentTypingDataModelProperties.TYPE");
        propertyNames.add("IComponentTypingDataModelProperties.COMPONENT");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("IComponentTypingDataModelProperties.SET_TYPE".equals(propertyName)) {
            return new Boolean(false);
        }
        return super.getDefaultProperty(propertyName);
    }

    public IStatus validate(String propertyName) {
        if (propertyName.equals("IComponentTypingDataModelProperties.COMPONENT")) {
            Component component = (Component)this.model.getProperty("IComponentTypingDataModelProperties.COMPONENT");
            boolean setType = this.model.getBooleanProperty("IComponentTypingDataModelProperties.SET_TYPE");
            String type = this.model.getStringProperty("IComponentTypingDataModelProperties.TYPE");
            Implementation oldImplementation = component.getImplementation();
            if (setType && oldImplementation != null && !(oldImplementation instanceof AbstractImplementation)) {
                String message = NLS.bind((String)Messages.stp_core_saf_unableToSetKindForTypedComponent, (Object)type);
                return SAFActivator.createErrorStatus(message, new InvalidOperationException(message));
            }
            return Status.OK_STATUS;
        }
        return super.validate(propertyName);
    }
}

