/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.builder;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.validation.BpmnValidationPlugin;
import org.eclipse.stp.bpmn.validation.IResourceImportersRegistry;
import org.eclipse.stp.bpmn.validation.providers.BpmnValidationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchValidationBuilder
extends IncrementalProjectBuilder {
    public static String GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID = "attachedFile";
    public static int DELTA_CONTENT_MASK = 340224;
    public static final String BUILDER_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuilder";
    private static GMFResourceFactory RESOURCE_FACTORY = new GMFResourceFactory();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        IResourceImportersRegistry rep = BpmnValidationPlugin.getResourceImportersRegistry(this.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, monitor);
        if (rep.isDirty()) {
            rep.save(this.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, monitor);
        }
        return null;
    }

    void checkBpmnResource(IResource resource, Set<IResource> collectExtraFilesToBuild, IProgressMonitor monitor) {
        Set<IResource> importers;
        if (resource instanceof IFile && resource.getName().endsWith(".bpmn_diagram")) {
            IFile file = (IFile)resource;
            try {
                BpmnValidationPlugin.getResourceImportersRegistry(this.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, monitor).clearImports((IResource)file);
                file.deleteMarkers("org.eclipse.stp.bpmn.validation.diagnostic", false, 0);
            }
            catch (CoreException coreException) {}
            if (file.exists()) {
                try {
                    BatchValidationBuilder.validateDiagramFile(file, monitor);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (collectExtraFilesToBuild != null && (importers = BpmnValidationPlugin.getResourceImportersRegistry(this.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, monitor).getImporters(resource)) != null) {
            collectExtraFilesToBuild.addAll(importers);
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.clean(monitor);
            this.getProject().accept((IResourceVisitor)new BpmnDiagramResourceVisitor(monitor));
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        BpmnDiagramResourceDeltaVisitor visitor = new BpmnDiagramResourceDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        for (IResource r : visitor.getExtraFilesToBuild()) {
            IResource r_diagram;
            if (!r.exists()) continue;
            if (r.getName().endsWith(".bpmn") && (r_diagram = this.getProject().findMember(r.getProjectRelativePath().removeFileExtension().addFileExtension("bpmn_diagram"))) != null && !visitor.isAlreadyBuilt(r_diagram)) {
                r = r_diagram;
            }
            this.checkBpmnResource(r, null, monitor);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null || !this.getProject().isAccessible()) {
            return;
        }
        BpmnValidationPlugin.getResourceImportersRegistry(this.getProject(), GENERIC_FILE_IMPORT_INDEX_CATEGORY_ID, monitor).clearAll();
        this.getProject().deleteMarkers("org.eclipse.stp.bpmn.validation.diagnostic", false, 2);
    }

    public static final void validateDiagramFile(IFile diagramFile, IProgressMonitor monitor) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn", RESOURCE_FACTORY);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn_diagram", RESOURCE_FACTORY);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/gmf/runtime/1.0.1/notation", (Object)NotationPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://stp.eclipse.org/bpmn", (Object)BpmnPackage.eINSTANCE);
        IPath bpmnPath = diagramFile.getFullPath().removeFileExtension().addFileExtension("bpmn");
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(bpmnPath) == null) {
            BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.stp.bpmn.validation", 2, "The diagram " + diagramFile.getFullPath().toPortableString() + " has no corresponding model: " + bpmnPath, null));
            return;
        }
        URI uriBpmn = URI.createURI((String)("platform:/resource" + diagramFile.getFullPath().removeFileExtension().toPortableString() + ".bpmn"));
        URI uriBpmnDiagram = URI.createURI((String)("platform:/resource" + diagramFile.getFullPath().toPortableString()));
        Resource resBpmn = resourceSet.createResource(uriBpmn);
        Resource resBpmnDiag = resourceSet.createResource(uriBpmnDiagram);
        resBpmnDiag.load(GMFResourceFactory.getDefaultLoadOptions());
        resBpmn.load(GMFResourceFactory.getDefaultLoadOptions());
        EList selectedEObjects = resBpmnDiag.getContents();
        if (selectedEObjects.isEmpty()) {
            BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.stp.bpmn.validation", 2, "The diagram " + diagramFile.getFullPath().toPortableString() + " was empty.", null));
            return;
        }
        monitor.setTaskName("Validate diagram " + diagramFile.getFullPath().toPortableString());
        for (EObject eobj : selectedEObjects) {
            if (!(eobj instanceof Diagram)) continue;
            Diagram diagram = (Diagram)eobj;
            try {
                BpmnValidationProvider.ValidateAction.runValidation((View)diagram);
            }
            catch (Exception e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, "Validation action failed", (Throwable)e));
            }
        }
        monitor.done();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BpmnDiagramResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor _monitor;
        Set<IResource> _extraResourcesToBuild = new HashSet<IResource>();
        Set<IResource> _alreadyBuilt = new HashSet<IResource>();

        BpmnDiagramResourceDeltaVisitor(IProgressMonitor monitor) {
            this._monitor = monitor;
        }

        public Set<IResource> getExtraFilesToBuild() {
            this._extraResourcesToBuild.removeAll(this._alreadyBuilt);
            return this._extraResourcesToBuild;
        }

        public boolean isAlreadyBuilt(IResource tobuild) {
            return this._alreadyBuilt != null && !this._alreadyBuilt.contains(tobuild);
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getFullPath().toString().indexOf("/.") != -1) {
                return false;
            }
            if (delta.getKind() == 4 && (delta.getFlags() & DELTA_CONTENT_MASK) == 0) {
                return true;
            }
            this._alreadyBuilt.add(resource);
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    BatchValidationBuilder.this.checkBpmnResource(resource, this._extraResourcesToBuild, this._monitor);
                }
            }
            return true;
        }
    }

    class BpmnDiagramResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor _monitor;

        BpmnDiagramResourceVisitor(IProgressMonitor monitor) {
            this._monitor = monitor;
        }

        public boolean visit(IResource resource) {
            BatchValidationBuilder.this.checkBpmnResource(resource, null, this._monitor);
            return true;
        }
    }
}

