/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.runtimeprovider;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExecutableExtension;

/**
 * this interface is used to define the service creation project structure
 * @author jma
 *
 */
public interface IProjectDirTemplate extends IExecutableExtension {
	
	/**
	 * get the folder for source code within project
	 * @param project
	 * @return
	 */
    public IFolder getSrcDir(IProject project);
    
    
    /**
     * set the source code dir
     * @param folder
     */
    public void setSrcDir(IFolder folder);
    
    
    /**
     * get the folder for wsdl files within project
     * @param project
     * @return
     */
    public IFolder getWsdlDir(IProject project);
    
    
    /**
     * get the folder for class files within project 
     * @param project
     * @return
     */
    public IFolder getClassFolder(IProject project);
    
}
