/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IPropertyCreationDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] Component who owns this property/s.
    * 
    * Type = {@link org.eclipse.stp.core.sca.ComponentType}
    */
   public static final String COMPONENT_TYPE = "IPropertyCreationDataModelProperties.COMPONENT_TYPE"; //$NON-NLS-1$

   /**
    * [OPTIONAL] Default value of the property.
    * 
    * Type = {@link String}
    */
   public static final String DEFAULT_VALUE  = "IPropertyCreationDataModelProperties.DEFAULT_VALUE"; //$NON-NLS-1$

   /**
    * [REQUIRED] Name of the property
    * 
    * Type = {@link String}
    */
   public static final String NAME           = "IPropertyCreationDataModelProperties.NAME";          //$NON-NLS-1$

   /**
    * [OPTIONAL]
    * 
    * Type = {@link Boolean} default value is TRUE
    */
   public static final String REQUIRED       = "IPropertyCreationDataModelProperties.REQUIRED";      //$NON-NLS-1$

   /**
    * [REQUIRED] Type of the property
    * 
    * Type = {@link Object}
    */
   public static final String TYPE           = "IPropertyCreationDataModelProperties.TYPE";          //$NON-NLS-1$

   /**
    * [REQUIRED] Many field for the property
    * 
    * Type = {@link Object}
    */
   public static final String MANY           = "IPropertyCreationDataModelProperties.MANY";          //$NON-NLS-1$
}
