/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.create.operations;

import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.resources.SOAConstants;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAObject;
import org.eclipse.stp.core.sca.SCAPackage;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class ModuleCreationOperation extends RootSCAModelCreationOperation {
   public ModuleCreationOperation(IDataModel model) {
      super(model);
   }

   protected URI getResourceURI() {
      // Build the composite resource URI and return it.
      String componentTypeName = model
            .getStringProperty(ICompositeCreationDataModelProperties.NAME);
      IContainer container = (IContainer) model
            .getProperty(ICompositeCreationDataModelProperties.CONTAINER);

      return URI.createPlatformResourceURI(container.getFullPath().append(
            componentTypeName + '.' + SOAConstants.MODULE_EXT).toString());
   }

   protected SCAObject createAndAddSCAModelToRoot(SCACoreRoot root) {
      if (root != null) {
         Module module = SCAPackage.eINSTANCE.getSCAFactory().createModule();

         module.setName(model
               .getStringProperty(ICompositeCreationDataModelProperties.NAME));

         if (module != null)
            root.setModule(module);

         return module;
      }

      return null;
   }
}
