/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IDeletePropertyDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] ComponentType who owns this property/s which are to be deleted.
    * 
    * Type = {@link org.eclipse.stp.core.sca.ComponentType}
    */
   public static final String COMPONENT_TYPE = "IDeletePropertyDataModelProperties.COMPONENT_TYPE"; //$NON-NLS-1$

   /**
    * [REQUIRED] Array of property names to be deleted.
    * 
    * The value basically tells which Property to be deleted. If no Property
    * with the given name is found nothing will happen.
    * 
    * Type = {@link java.lang.String []}
    */
   public static final String PROPERTY_NAMES = "IDeletePropertyDataModelProperties.PROPERTY_NAMES"; //$NON-NLS-1$	
}
