/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.delete.operations;

import org.eclipse.stp.core.infrastructure.operations.IAbstractScribblerDataModelProperties;

public interface IDeleteReferenceDataModelProperties extends
      IAbstractScribblerDataModelProperties {
   /**
    * [REQUIRED] ComponentType who owns this reference/s which are to be
    * deleted.
    * 
    * Type = {@link org.eclipse.stp.core.sca.ComponentType}
    */
   public static final String COMPONENT_TYPE  = "IDeleteReferenceDataModelProperties.COMPONENT_TYPE"; //$NON-NLS-1$

   /**
    * [REQUIRED] Array of reference names.
    * 
    * The value basically tells which reference to be deleted. If no reference
    * with the given name is found nothing will happen.
    * 
    * Type = {@link java.lang.String []}
    */
   public static final String REFERENCE_NAMES = "IDeleteReferenceDataModelProperties.REFERENCE_NAMES"; //$NON-NLS-1$
}
