/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.internal.introspection;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;

/**
 * A stack for managing attribute sets for the recursive stack parser.
 * 
 * @since 1.0
 * 
 */
public class AttributeSetStack {

   private final List stack = new ArrayList();

   public void push(AttributeSet anAttributeSet) {
      stack.add(anAttributeSet);
   }

   public AttributeSet peek() {
      if (stack.size() == 0)
         throw new EmptyStackException();
      return (AttributeSet) stack.get(stack.size() - 1);
   }

   public AttributeSet pop() {
      if (stack.size() == 0)
         throw new EmptyStackException();
      return (AttributeSet) stack.remove(stack.size() - 1);
   }

   public boolean isEmpty() {
      return stack.isEmpty();
   }
}
