/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;

public class ComponentTypeScribblerDomain extends SOACoreScribblerDomain
      implements IScribblerDomain {
   private final IFile                     component;

   private final IResourceDescriptor[]     descriptors;

   private final EclipseResourceDescriptor componentTypeDescriptor;

   public ComponentTypeScribblerDomain(IFile aComponentType) {
      super(aComponentType.getProject());
      component = aComponentType;
      if (SOAConstants.COMPONENT_TYPE_EXT.equals(aComponentType
            .getFileExtension()))
         componentTypeDescriptor = new EclipseResourceDescriptor(component);
      else
         componentTypeDescriptor = new EclipseResourceDescriptor(component,
               "comptype:"); //$NON-NLS-1$
      descriptors = new IResourceDescriptor[] { componentTypeDescriptor };
   }

   public IEditModelScribbler createScribblerForRead()
         throws EditModelException {
      return IEditModelFactory.eINSTANCE.createScribblerForRead(component
            .getProject(), this);
   }

   public IEditModelScribbler createScribblerForWrite()
         throws EditModelException {
      return IEditModelFactory.eINSTANCE.createScribblerForWrite(component
            .getProject(), this);
   }

   public IResourceDescriptor[] getResourceDescriptors() {
      return descriptors;
   }

   public EclipseResourceDescriptor getComponentTypeDescriptor() {
      return componentTypeDescriptor;

   }
}
