/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;

public class GeneralScribblerDomain extends DefaultScribblerDomain {

   private static final IResourceDescriptor[] NO_DESCRIPTORS = new IResourceDescriptor[0];

   private IProject                           project;

   public GeneralScribblerDomain(IProject aProject) {
      project = aProject;
   }

   public String getEditModelLabel() {
      return project.getName() + ".general"; //$NON-NLS-1$
   }

   public IResourceDescriptor[] getResourceDescriptors() {

      return NO_DESCRIPTORS;
   }

}
