/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.core.sca;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Abstract Implementation</b></em>'.
 * 
 * <p>
 * This interface is not intended to be implemented by clients.
 * </p>
 * <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.stp.core.sca.AbstractImplementation#getComponentType <em>Component Type</em>}</li>
 * <li>{@link org.eclipse.stp.core.sca.AbstractImplementation#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.stp.core.sca.SCAPackage#getAbstractImplementation()
 * @model extendedMetaData="name='AbstractImplementation' kind='elementOnly'"
 * @generated
 */
public interface AbstractImplementation extends Implementation {
   /**
    * <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @generated
    */
   String copyright = "Copyright (c) 2005, 2006 IBM Corporation. Licensed Material - Property of IBM. All rights reserved."; //$NON-NLS-1$

   /**
    * Returns the value of the '<em><b>Component Type</b></em>' containment
    * reference. <!-- begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Component Type</em>' containment reference
    * isn't clear, there really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Component Type</em>' containment
    *         reference.
    * @see #setComponentType(ComponentType)
    * @see org.eclipse.stp.core.sca.SCAPackage#getAbstractImplementation_ComponentType()
    * @model containment="true" resolveProxies="false" required="true"
    *        extendedMetaData="kind='element' name='componentType'
    *        namespace='##targetNamespace'"
    * @generated
    */
   ComponentType getComponentType();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.AbstractImplementation#getComponentType <em>Component Type</em>}'
    * containment reference. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Component Type</em>' containment
    *           reference.
    * @see #getComponentType()
    * @generated
    */
   void setComponentType(ComponentType value);

   /**
    * Returns the value of the '<em><b>Type</b></em>' attribute. <!--
    * begin-user-doc -->
    * <p>
    * If the meaning of the '<em>Type</em>' attribute isn't clear, there
    * really should be more of a description here...
    * </p>
    * <!-- end-user-doc -->
    * 
    * @return the value of the '<em>Type</em>' attribute.
    * @see #setType(String)
    * @see org.eclipse.stp.core.sca.SCAPackage#getAbstractImplementation_Type()
    * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.NCName"
    *        extendedMetaData="kind='attribute' name='type'"
    * @generated
    */
   String getType();

   /**
    * Sets the value of the '{@link org.eclipse.stp.core.sca.AbstractImplementation#getType <em>Type</em>}'
    * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
    * 
    * @param value
    *           the new value of the '<em>Type</em>' attribute.
    * @see #getType()
    * @generated
    */
   void setType(String value);

} // AbstractImplementation
